package com.zjty.switches.service.impl;

import com.zjty.switches.config.JdbcConnet;
import com.zjty.switches.service.SwitchService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;

@Service
@Slf4j
public class SwitchServiceImpl implements SwitchService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private JdbcConnet jdbcConnet;
    private Connection connection ;


    private void executeSQL(String sql) {
        jdbcTemplate.execute(sql);

    }

    @Override
    public void getChangeData(String sql, String tableName, String dbName) {
        String format = "%s同步到 %s %s： %s";
        String addr = "";
        try {
            if (tableName.contains("change_ds_")){
                //数据中心的数据
                addr = "数据中心";
                executeSQL(sql);
            }else {
                //前置数据库数据
                addr = "前置数据库";
                if (connection == null){
//                    JdbcConnet jdbcConnet = new JdbcConnet();
                    connection = jdbcConnet.connetToTest3();
                }
                Statement st = connection.createStatement();
                st.execute(sql);

            }
            log.info(String.format(format,dbName, addr, "成功",sql));
        }catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            log.info(String.format(format, dbName, addr, "失败",sql));

         }
    }

    @Override
    public void testData(int num){
        for (int i = 0; i < num; i++){
            String name = "张三" + i;
            String sql = "INSERT INTO change_ds_Student (id,age,name) VALUES ( " + i + "," +i + ",'" + name + "')";
            executeSQL(sql);
        }
    }

    @Override
    public void delectData(int num) {
        try {
            for (int i = 0; i < num; i++) {
                String sql = "delete from change_ds_Student where id=" + i;
                executeSQL(sql);
                String sql1 =  "delete from change_Student where id=" + i;

                if (connection == null) {
                    connection = jdbcConnet.connetToTest3();
                }
                Statement st = connection.createStatement();
                st.execute(sql1);

            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


}
