package com.zjty.catalog.service.impl;

import com.zjty.catalog.base.response.ServerResponse;
import com.zjty.catalog.domain.DatabaseInfo;
import com.zjty.catalog.service.BuildDBService;
import com.zjty.catalog.utils.DBConnectionUtil;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

@Service
public class BuildDBServiceImpl implements BuildDBService {

    @Override
    public ServerResponse buildDB(DatabaseInfo databaseInfo) {
        boolean isSuccess = true;
        Connection connection = DBConnectionUtil.databaseConnection("catalog");
        PreparedStatement preparedStatement = null;
        String sql = "CREATE DATABASE `" + databaseInfo.getName() + "` CHARACTER SET '" + databaseInfo.getCoding() + "' COLLATE '" + databaseInfo.getCollate() + "';";
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.execute();
        } catch (SQLException e) {
            e.printStackTrace();
            if(e.getMessage().contains("database exists")){
                isSuccess = false;
            }
        }finally {
            try {
                preparedStatement.close();
                connection.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if(isSuccess){
            return ServerResponse.success(databaseInfo);
        }else {
            return ServerResponse.error("数据库已存在");
        }
    }
}
