package com.zjty.switches.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import javax.sql.DataSource;

@ComponentScan
@Configuration
public class DataSourceConfig {
    @Primary
    @Bean(name = "remote1DataSource")
    @Qualifier("remote1DataSource")
    @ConfigurationProperties(prefix = "spring.datasource.remote1")
    public DataSource primaryDataSource() {
        return DruidDataSourceBuilder.create()
                .build();
    }
    @Bean(name = "remote2DataSource")
    @Qualifier("remote2DataSource")
    @ConfigurationProperties(prefix = "spring.datasource.remote2")
    public DataSource secondDataSource() {
        return DruidDataSourceBuilder.create()
                .build();
    }

}

