package com.zjty.switches.controller;

import com.alibaba.fastjson.JSONObject;
import com.zjty.switches.exchange.ChangeData;
import com.zjty.switches.service.SwitchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * @author LJJ cnljj1995@gmail.com
 * on 2020-03-04
 */
@RestController
@RequestMapping("/test")
public class TestController {
    @Autowired
    private  SwitchService switchService;

    @GetMapping("/asd")
    public ResponseEntity test() {
        return ResponseEntity.ok("success");
    }

    @PostMapping("/insert")
    public ResponseEntity insert(@RequestBody JSONObject jsonObject){
        String a=jsonObject.get("id").toString();
        int id=Integer.parseInt(a);
        Date start = new Date();
        switchService.testData(id);
        Date end = new Date();
        return ResponseEntity.ok(end.getTime() - start.getTime());
    }
    @PostMapping("/delete")
    public ResponseEntity deleted(@RequestBody JSONObject jsonObject){
        String a=jsonObject.get("id").toString();
        int id=Integer.parseInt(a);
        Date start = new Date();
        switchService.delectData(id);
        Date end = new Date();
        return ResponseEntity.ok(end.getTime() - start.getTime());
    }

    @PostMapping("/update")
    public  ResponseEntity update(@RequestBody JSONObject jsonObject){
        String a=jsonObject.get("id").toString();
        int id=Integer.parseInt(a);
        Date start = new Date();
        switchService.updateData(id);
        Date end = new Date();
        return ResponseEntity.ok(end.getTime() - start.getTime());
    }

    @PostMapping("/add")
    public ResponseEntity addObj(@RequestBody ChangeData changeData) {
        System.out.println(changeData);
        return ResponseEntity.ok(changeData);
    }

}
