package com.zjty.switches.utils;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class HttpUtils {
    public static String sendPost(String url, String jsonArgs) throws UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        //设置请求体
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        //设置请求数据
        HttpEntity<String> formEntity = new HttpEntity<>(jsonArgs, headers);
        String result = restTemplate.postForObject(url, formEntity, String.class);
        return result;

    }

    public static String sendGet(String url) throws UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        //restTemplate.getForObject(url, String.class);
        return restTemplate.getForObject(url, String.class);
    }

    public static String sendGet3(String url) throws UnsupportedEncodingException {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(1000 * 2);
        requestFactory.setReadTimeout(1000 * 2);
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        //restTemplate.getForObject(url, String.class);
        return restTemplate.getForObject(url, String.class);
    }

    public static String sendGet2(String url, String s) throws UnsupportedEncodingException {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        String result = restTemplate.getForObject(url, String.class, s);
        restTemplate.getForObject(url, String.class, s);
        return result;
    }
}
