package com.zjty.adaptationmaster.adaptor.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * <h4>Description : 项目类及需要改造的项目的基本信息</h4>
 *
 * @author : czq
 * @Date : 2019-12-06 9:52
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class Project {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    private String projectName;//项目名称

    private String language;//语言

    private String framework;//架构

    private String isSeparate;//前后端是否分离

    private String databaseType;//数据库类型

    private String codeUrl;//当前源码源码路径

    private Integer status = 1;//状态（0：删除 1：未删除）

    @Temporal(TemporalType.TIMESTAMP)
    private Date startTime = new Date();//开始时间

    @Temporal(TemporalType.TIMESTAMP)
    private Date updateTime;//更新时间

    @OneToMany(mappedBy = "project", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<Rule> rules;//自定义的规则

    @ManyToMany
    @JoinTable(name = "project_ruleSet",
            joinColumns = @JoinColumn(name = "p_id",referencedColumnName = "id"),
            inverseJoinColumns = @JoinColumn(name = "r_id", referencedColumnName = "id"))
    private List<RuleSet> ruleSets;//规则集
}
