package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.base.entity.ProjectStatueFromMiddleware;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
public class ApusicDeployer {
    private String ctlPath;
    private String ctlPwd;
    public void deploy(Project project,String webSocketName){
        String command = ctlPath+" -p '"+ctlPwd+"' install "+project.getProjectName()+" "+project.getReport().getPackagePath();
        appctl(command,webSocketName,project.getProjectName());
    }
    public List<ProjectStatueFromMiddleware> list(){
        List<ProjectStatueFromMiddleware> result = new ArrayList<>();
        String command = ctlPath+" -p '"+ctlPwd+"' list";
        try {
            Process exec = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
            boolean titleEnd = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if(line.startsWith("---------------"))titleEnd = true;
                if(titleEnd){
                    String[] split = line.split("\\s{2,}");
                    ProjectStatueFromMiddleware projectStatue = new ProjectStatueFromMiddleware(split[0],split[1],split[2]);
                    result.add(projectStatue);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
    public boolean start(String projectName,String webSocketName){
        String command = ctlPath+" -p '"+ctlPwd+"' start "+projectName;
        appctl(command,webSocketName,projectName);
        return true;
    }
    public boolean stop(String projectName,String webSocketName){
        String command = ctlPath+" -p '"+ctlPwd+"' stop "+projectName;
        appctl(command,webSocketName,projectName);
        return true;
    }
    private void appctl(String command,String webSocketName,String projectName){
        try {
            Process exec = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                WebSocketServer.sendInfo(line, webSocketName, "部署", "running", projectName);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
