package com.zjty.adaptationmaster.adaptor.entity;

import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.Dependency;
import com.zjty.adaptationmaster.utils.Inspector;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

/**
 * 返回
 * @author Mcj
 * @date 2020-01-03 10:33
 */
@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ReportEntity {
    @Id
    @GeneratedValue
    private Integer id;
    private Report.Language language;//语言
    private String framework;//架构
    private Report.DatabaseType databaseType;//数据库类型
    private int fileNum;
    private long lineNum;
    private Report.Separate isSeparate;//前后端是否分离
    private String compileFilePath;//项目编译文件，如果是maven项目，用maven编译，那么就是pom.xml
    public Report.DependenceManagement dependenceManagement;//版本管理方式
    private String packagePath;
    public String jarPath;//依赖文件的地址列表，用于编译，如果不是用版本管理工具
    @Column(columnDefinition = "text")
    private String warnList;
    private long createTime;
    public enum DependenceManagement{
        MAVEN,GRADLE,ANT
    }
    public enum Separate{
        WHOLE,SEPARATE
    }
    public enum DatabaseType{
        MYSQL,ORACLE,SQLSERVER,POSTGRE
    }
    public enum Language{
        JAVA,PYTHON,CPP,JSP,ASP,ONLYVIEW
    }
}
