package com.zjty.adaptationmaster.adaptor.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * <h4>Description : 项目类及需要改造的项目的基本信息</h4>
 *
 * @author : czq
 * @Date : 2019-12-06 9:52
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
@JsonIgnoreProperties(value = { "hibernateLazyInitializer", "handler" })
public class Project {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column(unique = true)
    private String projectName;//项目名称

    private String sourceDB;//原数据库
    private String createTypeDB;//目标数据库
    private String createMiddleware;//目标中间件
    private String operatingSystem;//操作系统
    private String cpu;//cpu

    private String codeUrl;//当前源码源码路径

    private String des;//描述

    private Integer stage;//阶段（0：源代码 1：替换后 2：编译后）

    private Integer status = 1;//状态（0：删除 1：未删除）

    @Temporal(TemporalType.TIMESTAMP)
    private Date startTime = new Date();//开始时间

    @Temporal(TemporalType.TIMESTAMP)
    private Date updateTime;//更新时间

    @OneToMany(mappedBy = "project", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<Rule> rules;//自定义的规则

    @ManyToMany
    @JoinTable(name = "project_ruleSet",
            joinColumns = @JoinColumn(name = "p_id",referencedColumnName = "id"),
            inverseJoinColumns = @JoinColumn(name = "r_id", referencedColumnName = "id"))
    private List<RuleSet> ruleSets;//规则集

    private boolean compileSuccess = false;
    @OneToOne
    private Report report;

    private boolean deploySuccess = false;

    private String deployPath = "编译路径";//不知道路径，等王永磊改

}
