package com.zjty.adaptationmaster;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class Compile {
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String OS_NAME = System.getProperty("os.name");

    public static void main(String[] args) throws IOException {
        String sourcePath = USER_DIR;
        if (args.length > 0) {
            sourcePath = getPath(args[0]);
        }

        Set<String> dirs = getSourceDirs(new File(sourcePath));

        String input = dirs.toString()
                .replace(",", "")
                .replace("[", "")
                .replace("]", "");
                
        System.out.println(input);        

        String output;
        if (args.length >= 2) {
            output = createDestDirectory(args[1]);
        } else {
            output = createDestDirectory("out");
        }
        
        // 打印将要执行的javac 命令
        System.out.println("javac -d " + output + " " + input);

        try {
            // 执行javac编译操作
            Runtime.getRuntime().exec("javac -d " + output + " " + input);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failure");
        }

        System.out.println("SUCCESS, The dest path is [" + output + "]");

    }

    // 创建class文件的存放目录 默认路径为当前工作路径下的out文件夹
            private static String createDestDirectory(String args) {
        String destPath = getPath(args);
        File file = new File(destPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    // 获取要编译的java源文件的目录， 并在目录的末尾添加上了 *.java
    private static Set<String> getSourceDirs(File file) {
        Set<String> resultDirs = new HashSet<>();
        if (file.isFile() && file.getName().endsWith(".java")) {
            resultDirs.add(file.getAbsolutePath().replace(file.getName(), "*.java"));
            return resultDirs;
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (File f : files) {
                resultDirs.addAll(getSourceDirs(f));
            }
        }
        return resultDirs;
    }


    // 根据传入的参数获取当前项目工作路径
    private static String getPath(String sourcePath) {
        String path;
        if (sourcePath == null) {
            return USER_DIR;
        }
        path = sourcePath.trim();

        if (!path.contains(":") && OS_NAME.toLowerCase().contains("windows")) {

            if (path.startsWith("\\") || path.startsWith("/")) {
                path = USER_DIR + path;
            } else {
                path = USER_DIR + FILE_SEPARATOR + path;
            }

            if (!(path.endsWith("\\") || path.endsWith("/"))) {
                path += FILE_SEPARATOR;
            }
        }

        if (OS_NAME.toLowerCase().contains("linux") && !path.startsWith("/")) {
            path = USER_DIR + FILE_SEPARATOR + path;
        }

        return path.replace("\\", FILE_SEPARATOR).replace("/", FILE_SEPARATOR);
    }
}
