package com.zjty.adaptationmaster.adaptor.service.Impl;


import com.zjty.adaptationmaster.adaptor.entity.db.DBDeleteResponse;
import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;
import com.zjty.adaptationmaster.adaptor.entity.db.DBRecord;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.repository.DBRecordDao;
import com.zjty.adaptationmaster.adaptor.service.DBManageService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Regular;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@Service
public class DBManageServiceImpl implements DBManageService {

    @Autowired
    private DBManageDao databaseDao;
    @Autowired
    private DBRecordDao dbRecordDao;

    @Value("${highgo.driver}")
    private String highgoDriver;
    @Value("${highgo.connectionType}")
    private String highgoConnnectionType;
    @Value("${highgo.dbName}")
    private String highgoDBName;

    /**
     * 新增数据库配置文件
     * @param databaseManagement
     * @return
     */
    @Override
    @Transactional
    public ServerResponse saveDatabase(DBManage databaseManagement) {
        databaseManagement.setStatus(1);//1-未删除
        return ServerResponse.success(databaseDao.save(databaseManagement));
    }


    /**
     * 根据id删除数据库配置文件
     * @param id
     * @return
     */
    @Override
    @Transactional
    public ServerResponse deleteDatabase(Integer id) {
        databaseDao.delete(id,0);//逻辑删除
        return ServerResponse.success(id);
    }

    /**
     * 查找未被逻辑删除的数据库配置文件
     * @return
     */
    @Override
    public ServerResponse findDatabase() {
        return ServerResponse.success(databaseDao.findDatabaseManagementByStatus(1));
    }


    /**
     * 数据库删除
     * @param dbDeleteResponse
     * @return
     */
    @Override
    @Transactional
    public ServerResponse deleteDB(DBDeleteResponse dbDeleteResponse) {
        DBManage dbManage = databaseDao.findDBManageByIdAndStatus(dbDeleteResponse.getId(),1);
        if(dbDeleteResponse.getDbType().equals("highgo")){
            dbManage.setDatabaseName(highgoDBName);
            dbManage.setDriver(highgoDriver);
            dbManage.setConnectionType(highgoConnnectionType);
        }
        Connection connection = Regular.databaseConnection(dbManage);
        if (connection != null) {
            PreparedStatement preparedStatement = null;
            try {
                String findDB = "DROP DATABASE IF EXISTS " + dbDeleteResponse.getDbName()+ ";";
                preparedStatement = connection.prepareStatement(findDB);
                preparedStatement.execute();
                dbRecordDao.delete(dbDeleteResponse.getDbName(),0);
            } catch (SQLException e) {
                e.printStackTrace();
                return ServerResponse.error(e.getMessage());
            } finally {
                try {
                    preparedStatement.close();
                    connection.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return ServerResponse.success();
    }
}
