package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.adaptor.service.AdaptationService;
import com.zjty.adaptationmaster.utils.ApusicDeployer;
import com.zjty.adaptationmaster.utils.FileUtil;
import com.zjty.adaptationmaster.utils.FileZip;
import com.zjty.adaptationmaster.utils.MavenCompiler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.IOException;
import java.util.List;

@Service
public class AdaptationServiceImpl implements AdaptationService {
    @Autowired
    private Adaptor adaptor;
    @Autowired
    private ProjectDao projectDao;
    @Override
    public ServerResponse adapt(Project project,List<Rule> rules,String uuid) throws IOException {
        adaptor.setRuleList(rules);
        adaptor.setProject(project);
        adaptor.setUuid(uuid);
        adaptor.doAdapt();
        return ServerResponse.success(project);
    }


    @Override
    public ServerResponse compile(Project project, String uuid) {
//        Project project = new Project();
//        project.setCompileFilePath("C:\\home\\project\\rsc\\hrmbclient\\pom.xml");
//        project.setDependenceManagement(Report.DependenceManagement.MAVEN);
        //Project project = projectDao.getOne(projectId);
        if(project.getReport()==null)return ServerResponse.error("请进行项目体检或完善项目信息");
        switch (project.getReport().getDependenceManagement()) {
            case MAVEN:
                new MavenCompiler(project, Const.MAVENHOME, uuid).compiler();

        }
        return ServerResponse.success(project);
    }

    @Override
    public ServerResponse deploy(Project project, String uuid) {
//        Project project = new Project();
//        project.setPackagePath("/home/user/Desktop/hrmanager-0.0.1-SNAPSHOT.war");
        //Project project = projectDao.getOne(projectId);
        new ApusicDeployer(Const.CTLPATH,Const.MAVENHOME).deploy(project,uuid);
        return ServerResponse.success(project);
    }

    @Transactional
    @Override
    public ServerResponse unZipProject(String path, Project project) {
        Project project1 = projectDao.getOne(project.getId());
        //FileUtil fileUtil = new FileUtil();
        project1.setCodeUrl(Const.UPLOAD_LOCATION+File.separator+project.getProjectName());
        try {
            FileZip.unzip(new File(path),project.getCodeUrl());
            project.setStage(project.getStage());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ServerResponse.success(project);
    }

    @Override
    public ServerResponse start(Project project, String uuid) {
        return ServerResponse.success(new ApusicDeployer(Const.CTLPATH,Const.MAVENHOME).start(project.getProjectName(),uuid));
    }

    @Override
    public ServerResponse stop(Project project, String uuid) {
        return ServerResponse.success(new ApusicDeployer(Const.CTLPATH,Const.MAVENHOME).stop(project.getProjectName(),uuid));
    }
}
