package com.zjty.adaptationmaster.utils;

import org.openqa.selenium.*;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import java.util.*;

@Component
public class SeleniumUtils {
    @Value("${driverweb}")
    private String driverweb;

    public  WebDriver initfifox() {
        System.out.println(driverweb);
        System.setProperty("webdriver.gecko.driver", driverweb);// 设置驱动类型和位置
        WebDriver driver = new FirefoxDriver();
        return driver;
    }
    public  String ElementAction(List<TestCase> steps) {
        WebDriver driver=null;
        try {
            driver=initfifox();
            Random random=null;
            for (TestCase step : steps) {
                Thread.sleep(1000);
                if(step.getAction().equalsIgnoreCase("get")){
                    driver.get(step.getElement());
                }else if(step.getAction().equalsIgnoreCase("sendkeys")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    if(value.equalsIgnoreCase("random")){
                        random=new Random();
                        int i = random.nextInt(1000)+1000;
                        value="test"+i;
                    }
//                driver.findElement(By.xpath(step.getElement())).sendKeys(value);
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.sendKeys(value);
                    System.out.println(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+" "+value);

                }else if(step.getAction().equalsIgnoreCase("click")){
//                driver.findElement(By.xpath(step.getElement())).click();
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.click();

                    System.out.println(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+" ");

                }else if(step.getAction().equalsIgnoreCase("gettext")){

                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    if("errorMsg".equalsIgnoreCase(step.getElement())){
                        if("".equals(webElement.getText())){
                            System.out.println("登录成功!");
                        }
                    }else {
                        webElement.getText();
                        System.out.println(webElement.getText());
                    }
                }else if(step.getAction().equalsIgnoreCase("readonly")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    JavascriptExecutor removeAttribute = (JavascriptExecutor)driver;
                    //remove readonly attribute
                    removeAttribute.executeScript("var setDate=document.getElementById(\""+step.getElement()+"\");setDate.removeAttribute('placeholder');");
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.sendKeys("1990-01-02");
                    System.out.println(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+" "+value);

                }else if(step.getAction().equalsIgnoreCase("register")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    if(value.equals(driver.getCurrentUrl())){
                        String text = driver.findElement(By.xpath(step.getElement())).getText();
                        System.out.println(text);
                    }else {
                        String errorMsg = driver.findElement(By.id("errorMsg")).getText();
                        System.out.println(errorMsg);

                    }

                }

            }
        }catch (Exception e){
            System.out.println(e.getMessage());
        }finally {
            driver.quit();
            if(driver!=null){
                driver=null;
            }
        }

        return null;//目前没有用，预留返回字段
    }

    private  WebElement selectType(String method, String element, WebDriver driver) {
        WebElement element1=null;
        if(method.equalsIgnoreCase("xpath")){
             element1 = driver.findElement(By.xpath(element));
        }else if(method.equalsIgnoreCase("css")){
            element1=driver.findElement(By.cssSelector(element));
        }else if(method.equalsIgnoreCase("id")){
            element1=driver.findElement(By.id(element));
        }else if(method.equalsIgnoreCase("name")){
            element1=driver.findElement(By.name(element));
        }
        return element1;
    }

}
