package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.MiddlewareManagement;
import com.zjty.adaptationmaster.adaptor.service.MiddlewareManagementService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 11:03
 */
@RestController
@RequestMapping("/middleware")
@Api(tags = "中间件管理")
public class MiddlewareController {

    private final MiddlewareManagementService middlewareManagementService;

    @Autowired
    public MiddlewareController(MiddlewareManagementService middlewareManagementService) {
        this.middlewareManagementService = middlewareManagementService;
    }

    @PutMapping
    public ServerResponse saveMiddleware(@RequestBody MiddlewareManagement middlewareManagement){
        return middlewareManagementService.saveMiddleware(middlewareManagement);
    }

    @DeleteMapping("/{id}")
    public ServerResponse deleteMiddleware(@PathVariable("id") Integer id){
        return middlewareManagementService.deleteMiddleware(id);
    }

    @PostMapping("/query")
    public ServerResponse findMiddleware(@RequestBody MiddlewareManagement middlewareManagement){
        return middlewareManagementService.findMiddleware(middlewareManagement);
    }
}
