package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.ListResponse;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.RuleSet;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.service.ProjectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-07 11:06
 */
@Service
public class ProjectServiceImpl implements ProjectService {

    private final ProjectDao projectDao;

    @Autowired
    public ProjectServiceImpl(ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    @Override
    public ServerResponse saveProject(Project project) {
        if(project.getId() == null){
            project.setUpdateTime(new Date());
        }
        Project save = projectDao.save(project);
        return ServerResponse.success("项目创建成功",save);
    }

    @Override
    @Transactional
    public ServerResponse deleteProject(Integer id) {
        Project project = projectDao.getOne(id);
        project.setStatus(0);
        project.setUpdateTime(new Date());
        return ServerResponse.success("删除成功");
    }

    @Override
    public ServerResponse findProject(Integer page,Project project) {
        Specification<Project> spec = Specifications.<Project>and()
                .like(project.getProjectName()!=null,"projectName","%"+project.getProjectName()+"%")
                .eq("status",1)
                .build();
        Pageable pageable = PageRequest.of(page-1, 10, Sort.Direction.DESC, "id");
        List<Project> projects = projectDao.findAll(spec,pageable).getContent();
        for (Project pro:projects) {
            //过滤删除的规则集
            List<RuleSet> ruleSets = pro.getRuleSets();
            List<RuleSet> sets = ruleSets.stream().filter(ruleSet -> ruleSet.getStatus() != 0).collect(toList());
            for (RuleSet set :sets) {
                List<Rule> rs = set.getRuleList().stream().filter(rule -> rule.getStatus() != 0).collect(toList());
                set.setRuleList(rs);
            }
            pro.setRuleSets(sets);
            //过滤删除的自定义规则
            List<Rule> rules = pro.getRules();
            List<Rule> collect = rules.stream().filter(rule -> rule.getStatus() != 0).collect(toList());
            pro.setRules(collect);
        }
        return ServerResponse.success(new ListResponse<>(projectDao.count(spec),projects));
    }
}
