package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.service.ProjectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 11:03
 */
@RestController
@RequestMapping("/project")
@Api(tags = "项目管理")
public class ProjectController {

    private final ProjectService projectService;

    @Autowired
    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }

    @PutMapping
    public ServerResponse saveProject(@RequestBody Project project){
        return projectService.saveProject(project);
    }

    @DeleteMapping("/{id}")
    public ServerResponse deleteProject(@PathVariable("id") Integer id){
        return projectService.deleteProject(id);
    }

    @PostMapping("/query/{page}")
    public ServerResponse findProject(@PathVariable("page") Integer page , @RequestBody Project project){
        return projectService.findProject(page,project);
    }

    @PostMapping("/getProjectState")
    public ServerResponse getProjectState(){
        return projectService.deployList();
    }

}
