package com.zjty.adaptationmaster.utils;

import com.alibaba.fastjson.JSONObject;
import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.base.entity.ProjectStatueFromMiddleware;
import com.zjty.adaptationmaster.base.enums.Const;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
public class ApusicDeployer {
    private String ctlPath;
    private String ctlPwd;
    public void deploy(Project project,String webSocketName){
        //String command = ctlPath+" -p "+ Const.CTLPWD +" install "+project.getProjectName()+" "+project.getReport().getPackagePath();
        String command = ctlPath +" install "+project.getProjectName()+" "+project.getReport().getPackagePath();
        System.out.println(command);
        appctl(command,webSocketName,project.getProjectName());
    }
    public List<ProjectStatueFromMiddleware> list(){
        List<ProjectStatueFromMiddleware> result = new ArrayList<>();
        String command = ctlPath+" list";
        System.out.println("command：" + command);
        try {
            Process exec = Runtime.getRuntime().exec(command);
            String password = Const.CTLPWD;
            OutputStream outputStream = exec.getOutputStream();
            outputStream.write(password.getBytes());
            outputStream.flush();
            outputStream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream(),"GBK"));
            boolean titleEnd = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                if(line.contains("---------------")){
                    titleEnd = true;
                    continue;
                }
                if(titleEnd){
                    String[] split = line.split("\\s{2,}");
                    ProjectStatueFromMiddleware projectStatue = null;
                    if(split.length < 3){
                        projectStatue = new ProjectStatueFromMiddleware(split[0],null,split[1]);
                    }else {
                        projectStatue = new ProjectStatueFromMiddleware(split[0],split[1],split[2]);
                    }
                    result.add(projectStatue);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
    public boolean start(String projectName,String webSocketName){
        String command = ctlPath+" start "+projectName;
        appctl(command,webSocketName,projectName);
        return true;
    }
    public boolean stop(String projectName,String webSocketName){
        String command = ctlPath+" stop "+projectName;
        appctl(command,webSocketName,projectName);
        return true;
    }
    private void appctl(String command,String webSocketName,String projectName){
        try {
            Process exec = Runtime.getRuntime().exec(command);
            String password = Const.CTLPWD;
            OutputStream outputStream = exec.getOutputStream();
            outputStream.write(password.getBytes());
            outputStream.flush();
            outputStream.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(exec.getInputStream(),"GBK"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                WebSocketServer.sendIn(webSocketName, TimeUtil.getNowDate()+"自动部署："+ projectName+line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
