package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.RuleSet;
import com.zjty.adaptationmaster.adaptor.service.RuleService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 11:03
 */
@RestController
@RequestMapping("/rule")
@Api(tags = "规则及规则集管理")
public class RuleController {

    private final RuleService ruleService;

    @Autowired
    public RuleController(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @PutMapping("/ruleSet")
    public ServerResponse addRuleSet(@RequestBody RuleSet ruleSet){
        return ruleService.addRuleSet(ruleSet);
    }

    @DeleteMapping("/ruleSet/{id}")
    public ServerResponse deleteRuleSet(@PathVariable("id") Integer id){
       return ruleService.deleteRuleSet(id);
    }

    @PostMapping("/ruleSet/query")
    public ServerResponse findRuleSet(@RequestBody RuleSet ruleSet){
        return ruleService.findRuleSet(ruleSet);
    }

//    @PutMapping("/toSet/{ruleSetId}")
//    public ServerResponse addRuleToSet(@RequestBody Rule rule ,@PathVariable("ruleSetId") Integer ruleSetId){
//        return ruleService.addRuleToSet(rule,ruleSetId);
//    }
//
//
//    @PutMapping("/toPro/{projectId}")
//    public ServerResponse addRuleToProject(@RequestBody Rule rule ,@PathVariable("projectId") Integer projectId){
//        return ruleService.addRuleToProject(rule,projectId);
//    }

    @DeleteMapping("/{id}")
    public ServerResponse deleteRule(@PathVariable("id") Integer id){
        return ruleService.deleteRule(id);
    }
}
