package com.zjty.adaptationmaster.adaptor.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

@Entity
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Rule {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private int id;
    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    @JSONField(serialize = false)
    @JoinColumn(name = "projectId")
    private Project project;//所属的项目

    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    @JSONField(serialize = false)
    @JoinColumn(name = "ruleSetId")
    private RuleSet ruleSet;//所属的规则集

    private Integer status = 1;//状态（0：删除 1：未删除）

    //private MatchType pathMatchType;//文件匹配方式    路径/文件名/后缀
    private String path;//文件路径匹配
    private String des;
    //private TextMatch textMatching;//文本匹配方式        全文匹配/正则匹配
    //private DealWay dealWay;//替换，在匹配字之前插入，在匹配字之后插入

    /**
     * AREA
     *      beginString||matching||endString
     */
    private String target;//文本匹配目标
    private String replacing;//更改方式              全文替换/正则替换

//    public enum MatchType{
//        PATH,NAME,SUFFIX,GLOB
//    }
//
//    public enum TextMatch{
//        AREA,CONTENT
//    }
//
//    public enum DealWay{
//        REPLACE,INSERTAFTER,INSERTBEFORE,InsertBetween
//    }
}
