package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;


public class ReadedFileTask implements Runnable {
    Logger logger = LoggerFactory.getLogger(getClass());

    private String projectName;
    private String uuid;
    private List<ReadedFile> readedFiles;
    //private Writer responseWriter;
    public ReadedFileTask(List<ReadedFile> readedFiles,String projectName,String uuid) {
        //System.out.println("一个线程");
        this.readedFiles = readedFiles;
        this.projectName = projectName;
        this.uuid = uuid;
    }

    private WriterBySort bySort;
    private int index;

    public void setBySort(WriterBySort bySort) {
        System.out.println("线程遇到大文件");
        this.bySort = bySort;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void run() {
        //System.out.println("进来线程");
        for(ReadedFile readedFile:readedFiles) {
            boolean match = false;
            String content = readedFile.getContent();
            //System.out.println("规则数量" + readedFile.getThisMatchedRule().size());
            for (Rule entity : readedFile.getThisMatchedRule()) {
                //在改动的地方加日志
//                int i = content.indexOf(entity.getTarget());
//                int i1 = content.lastIndexOf("\\r\\n", i);
//
                String replace = entity.getReplacing();
                String[] split;
                if(replace.contains("*")) {
                    logger.info("目标文本包含*，要记录*中的内容");
                    split = entity.getTarget().split("\\*");
                    int i = content.indexOf(split[0]);
                    int i1 = content.indexOf(split[1], i + split[0].length());
                    String temp = content.substring(i+split[0].length(),i1);
                    String[] split1 = replace.split("\\*");
                    replace = split1[0]+temp+split1[1];
                    content = content.substring(0,i)+replace+content.substring(i1);
                }else {
                    if(content.contains(entity.getTarget())){
                        try {
                            WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 代码替换：在文件" + readedFile.getPath().getFileName() + "中，找到关键字：\""+entity.getTarget()+"\",替换为"+replace);//"替换文件，找到文件"+ readedFile.getPath().getFileName());
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        match = true;
                        logger.info("找到目标"+readedFile.getPath().getFileName()+"目标："+entity.getTarget());

                    }
                    content = content.replaceAll(entity.getTarget(), replace);
//                    if(match){
//                        logger.info(content);
//                    }
                }
                //System.out.println("处理完成");
            }
            try {
                if (bySort != null) {
                    //System.out.println("bysort");
                    bySort.insert(index, content);
                } else {
                    //System.out.println("notbysort");
                    //logger.info(TimeUtil.getNowDate()+"内容替换：文件写出"+readedFile.getPath().getFileName());
                    if(match) {
                        //System.out.println(TimeUtil.getNowDate() + "内容替换：文件正在写出" + readedFile.getPath().getFileName());
                        //WebSocketServer.sendIn(uuid, TimeUtil.getNowDate() + "内容替换：文件写出" + readedFile.getPath().getFileName());
                    }
                    File file = readedFile.getPath().toFile();
                    file.createNewFile();
                    OutputStreamWriter contentWriter = new OutputStreamWriter(new FileOutputStream(file));
                    contentWriter.write(content);
                    contentWriter.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ReadedFile {
        private String content;
        private BasicFileAttributes attributes;
        private Path path;
        private List<Rule> thisMatchedRule;
    }
}
