package com.zjty.adaptationmaster.adaptor.controller;

import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.websocket.*;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

@ServerEndpoint("/webServer/{uuid}")
@Component
@Slf4j
public class WebSocketServer {
    private Logger logger = LoggerFactory.getLogger(getClass());

    private static Map<String,WebSocketServer> map = new HashMap<>();

    private Session session;

    private String uuid;

    @OnOpen
    public void onOpen(Session session,@PathParam("uuid")String uuid){
        this.session = session;
        this.uuid = uuid;
        //session.getOpenSessions().
        //System.out.println("第一个" + uuid);
        logger.info("uuid:"+uuid);
        map.put(uuid,this);
        try {
            sendMessage("连接成功");
        } catch (IOException e) {
            logger.error("websocket IO异常");
        }
        logger.info("连接成功"+session.getId());
    }

    @OnClose
    public void onClose(Session session){
        map.remove(this.uuid);
        logger.info("连接关闭"+session.getId());
    }

    @OnMessage
    public void onMessage(Session session,String message){
//        try {
            //map.get(uuid).sendMessage(message);
            logger.info(uuid+"sendMsg"+message);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
    }

    @OnError
    public void onError(Session session,Throwable error){
        logger.info(error.getMessage());
        error.printStackTrace();
    }
    /**
     * 实现服务器主动推送
     */
    public void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    public static void sendInfo(String sessionId,String msg,String action,String state,String projectName){

//        try {
//            //System.out.println(sessionId);
//            //map.get(sessionId).sendMessage(LocalDateTime.now()+"\t"+projectName+"\t"+action+"\t"+state+"\t"+msg);
//        } catch (IOException e) {
//                e.printStackTrace();
//        }
    }
    public static void sendIn(String sessionId,String message) throws IOException {
        try {
            map.get(sessionId).sendMessage(message);
        }catch (Exception e){
            log.info("向前台发送日志出错");
            //e.printStackTrace();
        }
    }

}
