package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.FileReturn;
import com.zjty.adaptationmaster.adaptor.service.FileUploadService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Service
public class FileUploadServiceImpl implements FileUploadService {

    /**
     * 前台文件上传
     * @param request
     * @return
     */
    @Override
    public ServerResponse fileUpload(HttpServletRequest request) {
        List<MultipartFile> multipartFiles = ((MultipartHttpServletRequest)request).getFiles("file");
        List<FileReturn> fileReturns = new ArrayList<>();
        for(MultipartFile multipartFile:multipartFiles){
            InputStream is = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            BufferedOutputStream bos = null;
            FileReturn fileReturn = new FileReturn();
            String sourceName = multipartFile.getOriginalFilename();
            String fileName = UUID.randomUUID().toString() + ".sql";
            //不存在该目录，创建目录
            File file = new File("/sqlFile/uploads");
            if(!file.exists()){
                file.mkdirs();
            }
            String savePath = file.getAbsolutePath() + "/" + fileName;
            fileReturn.setName(sourceName);
            fileReturn.setPath(savePath);
            fileReturns.add(fileReturn);
            File createFile = new File(savePath);
            try {
                is = multipartFile.getInputStream();
                bis = new BufferedInputStream(is);
                fos = new FileOutputStream(createFile);
                bos = new BufferedOutputStream(fos);
                int len = -1;
                byte[] b = new byte[1024];
                while ((len = bis.read(b)) != -1){
                    bos.write(b,0,len);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }finally {
                try {
                    bis.close();
                    is.close();
                    bos.close();
                    fos.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ServerResponse.success(fileReturns);
    }
}
