package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;

    @Transactional
    @Override
    public ServerResponse inspect(int projectId) {
        Project project = projectDao.getOne(projectId);
        return ServerResponse.success(new Inspector(project,new HashMap<>(),new HashMap<>(),new ArrayList<>()).inspect());
    }
}
