package com.zjty.adaptationmaster.adaptor.enginer;

import com.zjty.adaptationmaster.adaptor.entity.AdaptationDetailsLogEntity;
import com.zjty.adaptationmaster.adaptor.entity.OriginalFile;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.base.enums.Const;
import com.zjty.adaptationmaster.managerment.dao.AdaptationDetailLogEntityDao;
import com.zjty.adaptationmaster.managerment.dao.OriginalFileDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.*;
import java.nio.charset.Charset;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Component
public class Adaptor {
    //@Autowired
    //private AdaptationDetailLogEntityDao adaptationDetailLogEntityDao;
    @Autowired
    private OriginalFileDao originalFileDao;
    //@Value("${base.path}")
    private String basePath = Const.CONSOLE;
    //线程池数量，合适的线程数量能让程序更快
    private static final int poolSize = 20;
    //为避免内存溢出，对于超大文件，切分成部分分别读入处理，最后拼接写出
    private static final long LIMIT = 200*1024*1024;
    //将适配进度写出，用于页面实时展示
    PrintWriter responseWriter;
    List<Rule> ruleList;
    String projectPath;
    //private List<Rule> adaptorEntities = new ArrayList<>();

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public void setRuleList(List<Rule> ruleList) {
        this.ruleList = ruleList;
    }

    public void setWriter(PrintWriter writer) {
        this.responseWriter = writer;
    }

    public void doAdapt(){
        //String regular = preprocesAdaptation();
        //List<String> strings1 = preprocessRegular();
        Map<String, Rule> strings1 = preprocessRegular();
        if(strings1.size()<1){
            System.out.println("检测到匹配规则为空");
            return;
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(poolSize,poolSize,10, TimeUnit.SECONDS,new ArrayBlockingQueue<>(poolSize*2));
        pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        List<OriginalFile> originalFiles = new ArrayList<>();
        //记录实际具体适配内容
        //List<AdaptationDetailsLogEntity> detailsLogEntities = new ArrayList<>();
        ReadedFileRepository repository = new ReadedFileRepository();
        try {
            Files.walkFileTree(Paths.get(projectPath),new SimpleFileVisitor<Path>() {
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {

//                    String pathString = file.toString();
//                    pathString.indexOf(System.getProperty("file.separator"),basePath.length());

                    boolean match = false;
                    List<Rule> thisFileMatched = null;
                    //不符合规则的路径过滤掉
                    for(String regular:strings1.keySet()) {
                        if (FileSystems.getDefault().getPathMatcher("glob:"+regular).matches(file)) {
                            if(thisFileMatched==null)
                                thisFileMatched = new ArrayList<>();
                            thisFileMatched.add(strings1.get(regular));
                            match = true;
                        }
                    }
                    String storePath ="originalFile/"+ UUID.randomUUID().toString()+"/"+file.getFileName();
                    //原先文件的新地址
                    Path originalPath = Paths.get(basePath +storePath);
                    File parentFile = originalPath.toFile().getParentFile();
                    if(!parentFile.exists()||!parentFile.isDirectory())parentFile.mkdirs();
                    if(match) {
                        OriginalFile originalFile = new OriginalFile(file.toString(),originalPath.toString(),new Date());
                        originalFiles.add(originalFile);
                        Files.move(file, originalPath);
                        //splitedFile.setDeal(true);
                        System.out.println("过滤得到符合规则的文件" + file);
                        if (attrs.size() > LIMIT) {
                            System.out.println("找到大文件" + file);
                            ReadedLinesRepository linesRepository = new ReadedLinesRepository();
                            int i = 0;
                            WriterBySort bySort = new WriterBySort();
                            File newFile = file.toFile();
                            newFile.createNewFile();
                            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(newFile), "utf-8");
                            bySort.setWriter(writer);
                            for (String s : Files.readAllLines(originalPath, Charset.forName("utf-8"))) {
                                if (linesRepository.put(s)) {
                                    List<ReadedFile> readedFiles = new ArrayList<>();
                                    readedFiles.add(new ReadedFile(linesRepository.getReadedFiles(), attrs, file,thisFileMatched));
                                    ReadedFileTask apacheTask = new ReadedFileTask(readedFiles);
                                    apacheTask.setBySort(bySort);
                                    apacheTask.setIndex(i);
                                    pool.submit(apacheTask);
                                    i++;
                                }
                            }
                            List<ReadedFile> readedFiles = new ArrayList<>();
                            readedFiles.add(new ReadedFile(linesRepository.getReadedFiles(), attrs, file,thisFileMatched));
                            ReadedFileTask apacheTask = new ReadedFileTask(readedFiles);
                            apacheTask.setBySort(bySort);
                            apacheTask.setIndex(i);
                            pool.submit(apacheTask);
                            i++;
                            bySort.setSize(i);
                        }else {
                            String s = new String(Files.readAllBytes(originalPath));
                            ReadedFile readedFile = new ReadedFile(s, attrs, file,thisFileMatched);
                            if (repository.put(readedFile)) {
                                ReadedFileTask apacheTask = new ReadedFileTask(repository.getReadedFiles());
                                pool.submit(apacheTask);
                            }
                        }
                    }/*else {
                        Files.copy(file, Paths.get(newPath));
                    }*/
                    return FileVisitResult.CONTINUE;
                }
            });
            ReadedFileTask apacheTask = new ReadedFileTask(repository.getReadedFiles());
            pool.submit(apacheTask);
            pool.shutdown();
            try {
                pool.awaitTermination(1,TimeUnit.HOURS);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            originalFileDao.saveAll(originalFiles);
            //adaptationDetailLogEntityDao.saveAll(detailsLogEntities);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 预处理适配规则，将规则实体类处理成glob表达式
     * @return
     */
    private Map<String,Rule> preprocessRegular() {
        //List<String> result = new ArrayList<>();
        Map<String,Rule> result = new HashMap<>();
        for (Rule adaptorEntity : ruleList) {
            switch (adaptorEntity.getPathMatchType()) {
                case SUFFIX:
                    result.put("**/**" + adaptorEntity.getPath(),adaptorEntity);
                    break;
                case PATH:
                    result.put("" + adaptorEntity.getPath(),adaptorEntity);
                    break;
                case NAME:
                    result.put("**/" + adaptorEntity.getPath(),adaptorEntity);
                    break;
            }
        }
        return result;
    }

    /**
     * 对于大文件，按行读取，积攒到一定大小去处理
     * 这里put进来每行
     * 大小不够时返回false
     * 大小够时返回true
     */
    private class ReadedLinesRepository{
        private static final long LIMIT = 200*1024*1024;//字节*k*m

        private List<StringBuilder> readedFiles;
        private long count;

        public String getReadedFiles() {
            return readedFiles.toString();
        }

        public boolean put(String readedFile){
            if(readedFiles==null)readedFiles = new ArrayList<>();
            readedFiles.add(new StringBuilder(readedFile));
            count+=readedFile.length();
            if(count>LIMIT){
                return true;
            }
            return false;
        }
    }

    /**
     * 读取到的大量小文件，积累到一定的大小，才交给一个线程去处理
     */
    private class ReadedFileRepository{
        private List<ReadedFile> readedFiles;
        private long count;

        public List<ReadedFile> getReadedFiles() {
            return readedFiles;
        }

        public boolean put(ReadedFile readedFile){
            if(readedFiles==null)readedFiles = new ArrayList<>();
            readedFiles.add(readedFile);
            count+=readedFile.getAttributes().size();
            if(count>LIMIT){
                return true;
            }
            return false;
        }
    }

    /**
     * 过大的文件，切割成几块，每块编号，分给每个线程处理，处理结束后，按编号顺序写出
     * 这里按编号控制写出顺序
     */
    public class WriterBySort{
        private int currentIndex = -1;
        private Map<Integer,String> map = new TreeMap<>();
        private Writer contentWriter;
        private int size;

        public void setWriter(Writer writer) {
            this.contentWriter = writer;
        }
        public void setSize(int size) {
            this.size = size;
            if(currentIndex==size){
                try {
                    contentWriter.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        public void insert(Integer key, String value){
            map.put(key,value);
            while (map.get(currentIndex+1)!=null){
                try {
                    contentWriter.write(map.remove(currentIndex+1));
                } catch (IOException e) {
                    e.printStackTrace();
                }
                currentIndex++;
                if(currentIndex == size){
                    try {
                        contentWriter.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

}
