package com.zjty.adaptationmaster.adaptor.service;

import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.RuleSet;
import com.zjty.adaptationmaster.base.response.ServerResponse;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 9:28
 */
public interface RuleService {
    /**
     * 添加规则集
     * @param ruleSet 规则集信息
     * @return 添加成功
     */
    ServerResponse addRuleSet(RuleSet ruleSet);

    /**
     * 删除规则集，逻辑删除
     * @param id 规则集id
     * @return 删除成功
     */
    ServerResponse deleteRuleSet(Integer id);

    /**
     * 查询规则集，查询全部，无需分页
     * @param ruleSet 查询条件
     * @return 规则集集合
     */
    ServerResponse findRuleSet(RuleSet ruleSet);

//    /**
//     * 添加规则到规则集
//     * @param rule 规则信息
//     * @param ruleSetId 规则集id
//     * @return 返回成功
//     */
//    ServerResponse addRuleToSet(Rule rule , Integer ruleSetId);
//
//    /**
//     * 添加规则到项目，即自定义规则
//     * @param rule 规则内容
//     * @param projectId 项目id
//     * @return 返回成功
//     */
//    ServerResponse addRuleToProject(Rule rule , Integer projectId);

    /**
     * 删除规则，逻辑删除
     * @param id 规则id
     * @return 删除成功
     */
    ServerResponse deleteRule(Integer id);
}
