package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSON;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.entity.ReportEntity;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.Dependency;
import com.zjty.adaptationmaster.adaptor.repository.PomDependencyDao;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.repository.ReportDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ReportDao reportDao;
    @Autowired
    private PomDependencyDao pomDependencyDao;

    @Transactional
    @Override
    public ServerResponse inspect(Project project) {
        if(project.getCodeUrl() != null && !project.getCodeUrl().equals("")){
            //Project project = projectDao.getOne(projectId);
            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
            suffixLanguageMapping.put("java",Report.Language.JAVA);
            suffixLanguageMapping.put("cpp",Report.Language.CPP);
            suffixLanguageMapping.put("py",Report.Language.PYTHON);
            suffixLanguageMapping.put("jsp",Report.Language.JSP);
            suffixLanguageMapping.put("asp",Report.Language.ASP);
            //suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
            LoggerFactory.getLogger(getClass()).info("这里rulelist为空，需要设置");
            Report report = new Inspector(project, suffixLanguageMapping, new ArrayList<>()).inspect();

            ReportEntity reportEntity = new ReportEntity();
            reportEntity.setCompileFilePath(report.getCompileFilePath());
            reportEntity.setDatabaseType(report.getDatabaseType());
            reportEntity.setDependenceManagement(report.getDependenceManagement());
            reportEntity.setFileNum(report.getFileNum());
            reportEntity.setFramework(report.getFramework());
            reportEntity.setIsSeparate(report.getIsSeparate());
            reportEntity.setLanguage(report.getLanguage());


            List<Inspector.Warn> warnList = report.getWarnList();
            String s1 = JSON.toJSONString(warnList);
            reportEntity.setWarnList(s1);
            List<String> jarPath = report.getJarPath();
            String s2 = JSON.toJSONString(jarPath);
            reportEntity.setJarPath(s2);
            if(report.getPackagePath() == null){
                reportEntity.setPackagePath(project.getCodeUrl());
            }

            ReportEntity reportEntitySave = reportDao.save(reportEntity);
            Project one = projectDao.getOne(project.getId());
            List<Dependency> dependencies = report.getDependencies();
            for (Dependency dependency : dependencies) {
                dependency.setReportId(reportEntitySave.getId());
            }
            pomDependencyDao.saveAll(dependencies);
            one.setReport(reportEntitySave);
            return ServerResponse.success(reportEntitySave);
        }else{
            return ServerResponse.error("未上传源代码");
        }
    }

    @Override
    public Report getReportById(Integer id) {
        ReportEntity one = reportDao.getOne(id);
        Report report = new Report();

        List<Dependency> allByReportIdEquals = pomDependencyDao.findAllByReportIdEquals(id);
        report.setId(one.getId());
        report.setDependencies(allByReportIdEquals);
        report.setDatabaseType(one.getDatabaseType());
        report.setLanguage(one.getLanguage());
        report.setPackagePath(one.getPackagePath());
        report.setCompileFilePath(one.getCompileFilePath());
        report.setDependenceManagement(one.getDependenceManagement());
        report.setFileNum(one.getFileNum());
        report.setLineNum(one.getLineNum());
        report.setFramework(one.getFramework());
        report.setIsSeparate(one.getIsSeparate());

        List<Inspector.Warn> warns = JSON.parseArray(one.getWarnList(), Inspector.Warn.class);
        report.setWarnList(warns);

        List<String> path = JSON.parseArray(one.getJarPath(), String.class);
        report.setJarPath(path);
        return report;
    }
}
