package com.zjty.adaptationmaster.utils;

import com.alibaba.fastjson.JSON;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.yaml.snakeyaml.Yaml;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;

public class YamlReader {
    private String path;
    private Map<String,Map> map;
    public YamlReader(String path){
        this.path = path;
        Yaml yaml = new Yaml();
        try {
            map = yaml.loadAs(new FileInputStream(path),Map.class);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
    public String getSpringDatasourceUrl(){
        return (String) ((Map)((map.get("spring")).get("datasource"))).get("url");
    }

    public static void main(String[] args) {
        String s = "# mybatis\n" +
                "mybatis:\n" +
                "    type-aliases-package: info.ideatower.component.inscriber.entity\n" +
                "    mapper-locations: classpath:mapping/*.xml\n" +
                "    config-locations: classpath:mybatis-config.xml\n" +
                "\n" +
                "# 应用组件通信等配置\n" +
                "component:\n" +
                "    misso:\n" +
                "        log:\n" +
                "            addr: http://localhost:8009\n" +
                "    error:\n" +
                "        enable: on\n" +
                "\n" +
                "Related:\n" +
                "    Projects:\n" +
                "        - Rx\n" +
                "        - Kwalify\n" +
                "        - yaml_vim\n" +
                "        - yatools.net\n" +
                "        - JSON\n" +
                "        - Pygments";
        String s1 = "logging:\n" +
                "  level:\n" +
                "    root: debug\n" +
                "    com.cax: debug\n" +
                "  file: logs/debug.log\n" +
                "spring:\n" +
                "  datasource:\n" +
                "    driver-class-name: com.mysql.cj.jdbc.Driver\n" +
                "    url: jdbc:mysql://localhost:3306/book?useUnicode=true&characterEncoding=utf-8&serverTimezone=UTC\n" +
                "    username: root\n" +
                "    password:\n" +
                "  jpa:\n" +
                "    hibernate:\n" +
                "      ddl-auto: create\n" +
                "    show-sql: true\n" +
                "    open-in-view: false\n";
        Yaml yaml = new Yaml();
        Map<String,Map> map = yaml.loadAs(s1, Map.class);
        System.out.println(((Map)(map.get("spring")).get("datasource")).get("url"));
        //System.out.println(ymmm.getSpring().getDataSource().getDriverClassName());
//        System.out.println(map);
//        for (Map.Entry<String,Map> entry:map.entrySet()){
//            System.out.println(entry);
//
//            System.out.println(entry.getValue());
////            System.out.println(entry.getKey()+"\t"+entry.getValue());
//        }
        //只能解析map和properties
//        YamlMapFactoryBean yamlMapFactoryBean = new YamlMapFactoryBean();
//        yamlMapFactoryBean.setResources(new ClassPathResource("test.yml"));
//        Map<String, Object> object = yamlMapFactoryBean.getObject();
//        ymmm ymmm = ((ymmm)object);
//        System.out.println(ymmm.getSpring().getDataSource().getDriverClassName());
        //ymmm ymmm = JSON.parseObject(s1, ymmm.class);
        //System.out.println(ymmm.getSpring().getDataSource().getDriverClassName());
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public class DataSource{
        private String driverClassName;
        private String url;
        private String username;
        private String password;
    }
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public class spring{
        private DataSource dataSource;
    }
    @Data
    public class ymmm{
        private spring spring;
        public ymmm(){

        }
        public ymmm(spring spring){
            this.spring = spring;
        }
    }
}
