package com.zjty.adaptationmaster.adaptor.entity.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLExecuteTask implements Runnable{

    private Connection connection;

    private String sql;

    public SQLExecuteTask(Connection connection){
        this.connection = connection;
    }
    public void setSql(String sql){
        this.sql = sql;
    }
    @Override
    public void run() {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setQueryTimeout(10);
            preparedStatement.execute();
        } catch (SQLException e) {
            e.printStackTrace();
        }finally {
            try {
                preparedStatement.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}
