package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.MiddlewareManagement;
import com.zjty.adaptationmaster.adaptor.repository.MiddlewareManagementDao;
import com.zjty.adaptationmaster.adaptor.service.MiddlewareManagementService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <h4>Description : 中间件管理</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-07 11:06
 */
@Service
public class MiddlewareManagementServiceImpl implements MiddlewareManagementService {

    private final MiddlewareManagementDao middlewareManagementDao;

    @Autowired
    public MiddlewareManagementServiceImpl(MiddlewareManagementDao middlewareManagementDao) {
        this.middlewareManagementDao = middlewareManagementDao;
    }

    @Override
    public ServerResponse saveMiddleware(MiddlewareManagement middlewareManagement) {
        MiddlewareManagement save = middlewareManagementDao.save(middlewareManagement);
        return ServerResponse.success(save);
    }

    @Override
    @Transactional
    public ServerResponse deleteMiddleware(Integer id) {
        MiddlewareManagement middlewareManagement = middlewareManagementDao.getOne(id);
        middlewareManagement.setStatus(0);
        return ServerResponse.success("删除成功");
    }

    @Override
    public ServerResponse findMiddleware(MiddlewareManagement middlewareManagement) {
        Specification<MiddlewareManagement> spec = Specifications.<MiddlewareManagement>and()
                .eq("status",1)
                .build();
        List<MiddlewareManagement> all = middlewareManagementDao.findAll(spec);
        return ServerResponse.success(all);
    }
}
