package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.tomcat.websocket.server.WsServerContainer;

import java.io.*;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;


public class ReadedFileTask implements Runnable {

    private String projectName;
    private String uuid;
    private List<ReadedFile> readedFiles;
    //private Writer responseWriter;
    public ReadedFileTask(List<ReadedFile> readedFiles,String projectName,String uuid) {
        //System.out.println("一个线程");
        this.readedFiles = readedFiles;
        this.projectName = projectName;
        this.uuid = uuid;
    }

    private WriterBySort bySort;
    private int index;

    public void setBySort(WriterBySort bySort) {
        System.out.println("线程遇到大文件");
        this.bySort = bySort;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void run() {
        System.out.println("进来线程");
        for(ReadedFile readedFile:readedFiles) {
            String content = readedFile.getContent();
            System.out.println("规则数量" + readedFile.getThisMatchedRule().size());
            for (Rule entity : readedFile.getThisMatchedRule()) {
                //在改动的地方加日志
//                int i = content.indexOf(entity.getTarget());
//                int i1 = content.lastIndexOf("\\r\\n", i);
//
                String replace = entity.getReplacing();
                String[] split;
                if(replace.contains("*")) {
                    split = entity.getTarget().split("\\*");
                    int i = content.indexOf(split[0]);
                    int i1 = content.indexOf(split[1], i + split[0].length());
                    String temp = content.substring(i+split[0].length(),i1);
                    String[] split1 = replace.split("\\*");
                    replace = split1[0]+temp+split1[1];
                    content = content.substring(0,i)+replace+content.substring(i1);
                }else {
                    content = content.replaceAll(entity.getTarget(), replace);
                }
                System.out.println("处理完成");
            }
            try {
                if (bySort != null) {
                    System.out.println("bysort");
                    bySort.insert(index, content);
                } else {
                    System.out.println("notbysort");
                    WebSocketServer.sendInfo(uuid, readedFile.getPath().getFileName() + "", "替换", "正在写出", projectName);
                    File file = readedFile.getPath().toFile();
                    file.createNewFile();
                    OutputStreamWriter contentWriter = new OutputStreamWriter(new FileOutputStream(file));
                    contentWriter.write(content);
                    contentWriter.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class ReadedFile {
        private String content;
        private BasicFileAttributes attributes;
        private Path path;
        private List<Rule> thisMatchedRule;
    }
}
