package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;

import java.io.*;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Regular {

    /**
     * 将mysql导出的.sql文件转为highgo可以识别的.sql文件
     * @param path  sql文件地址
     * @param sqlName   数据库名字
     */
    public static String mySqlRegular(String path, String sqlName){
        File file = new File(path);
        File fileParent = new File(file.getParent() + "/transformSql");
        if(!fileParent.exists()){
            fileParent.mkdirs();
        }
        String savePath = fileParent.getAbsolutePath() + "/" + sqlName + ".sql";//导出的sql地址
        File saveFile = new File(savePath);
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            fileWriter = new FileWriter(saveFile);
            bufferedWriter = new BufferedWriter(fileWriter);
            String s;
            boolean isFirstDrop = false;//去除.sql中使用数据库的sql语句
            String tableName = "";//数据库名称
            String incrementField = "";//自增长字段
            List<String> foreignList = new ArrayList<>();//外键集合
            List<String> indexList = new ArrayList<>();//索引集合
            String previous = "";//上一个读取的行
            String createTableSql = "";
            boolean createLock = true;
            boolean executeOne = true;
            while ((s = bufferedReader.readLine()) != null){
                s = s.replaceAll("`","\"");
                s += "\r\n";
                if(lowerAndUpper(s,"INSERT") && lowerAndUpper(s,"INTO")){
                    //将\0与\1替换为true或false
                    s = s.replace("'\\0'","'false'");
                    s = s.replace("'\\1'","'true'");
                    s = s.replaceAll("'0000-00-00 00:00:00'","null");
                    s = s.replace("\\\\","\\");//转义\
                    s = s.replace("\\\"","\"");//转义"
                    s = s.replace("\\'","''");//转义'
                    bufferedWriter.write(s);
                    continue;
                }
                //记录自增字段
                if(lowerAndUpper(s,"PRIMARY") && lowerAndUpper(s,"KEY")){
                    incrementField = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\""));
                    s = replaceLowerAndUpper(s,"USING","");
                    s = replaceLowerAndUpper(s,"BTREE","");
                    s = replaceLowerAndUpper(s,",","");
                }
                //记录创建表时表的名字
                if(lowerAndUpper(s,"CREATE") && lowerAndUpper(s,"TABLE")){
                    tableName = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\"")).trim();
                    createLock = false;
                }
                //转换mysql的int和bigint类型
                if(lowerAndUpper(s,"INT(")){
                    String dataType = s.substring(s.lastIndexOf("\"") + 1,s.indexOf("(")).trim();
                    String startChar = s.substring(0,s.indexOf("("));
                    String endChar = s.substring(s.indexOf(")") + 1);
                    if(dataType.length() <= 4){
                        //int类型
                        s = startChar + "4" + endChar;
                        if(lowerAndUpper(s,"AUTO_INCREMENT")){
                            s = replaceLowerAndUpper(s,"INT4","serial");
                        }
                    }else {
                        s = startChar + endChar;
                        //bigint类型
                        if(lowerAndUpper(s,"BIGINT") && lowerAndUpper(s,"AUTO_INCREMENT")){
                            s = replaceLowerAndUpper(s,"BIGINT","bigserial");
                        }else if(lowerAndUpper(s,"SMALLINT") && lowerAndUpper(s,"AUTO_INCREMENT")){
                            s = replaceLowerAndUpper(s,"SMALLINT","smallserial");
                        }
                    }
                    s = replaceLowerAndUpper(s,"tinyint","smallint");
                    s = replaceLowerAndUpper(s,"AUTO_INCREMENT","");
                }
                //转换mysql的时间datetime类型
                s = StringType(s,"datetime","timestamp");
                //转换mysql的double类型
                s = StringType(s,"double","real");
                //插入值时boolean类型转换
                s = replaceLowerAndUpper(s,"BIT(1)","boolean");
                //替换longtext
                s = replaceLowerAndUpper(s,"longtext","text");
                //替换mediumtext
                s = replaceLowerAndUpper(s,"mediumtext","text");
                //从第一个创建表的可执行命令开始
                if(lowerAndUpper(s,"DROP") && lowerAndUpper(s,"TABLE") && executeOne){
                    isFirstDrop = true;
                    executeOne = false;
                }
                //去除表类型的定义
                if(lowerAndUpper(s,"ENGINE") && (lowerAndUpper(s,"CHARSET") || lowerAndUpper(s,"CHARACTER "))){
                    //String[] array = s.split(" ");
                    if(lowerAndUpper(s,"AUTO_INCREMENT")){
                        int begin = stringIndex(s,"AUTO_INCREMENT");
                        for(int i = begin;i < s.length();i++){
                            String ca = s.charAt(i) + "";
                            if(ca.matches("\\d")){
                                s = s.substring(i);
                                String num = s.substring(0,s.indexOf(" "));
                                s = ");\r\nSELECT setval('\"" + tableName + "_" + incrementField + "_seq\"'," +  (Integer.parseInt(num) - 1) + ", true);\r\n";
                                break;
                            }
                        }
                    }else {
                        s = ");\r\n";
                    }
                }
                //msql的外键设置移动位置
                if(lowerAndUpper(s,"FOREIGN") && lowerAndUpper(s,"KEY") && lowerAndUpper(s,"CONSTRAINT")){
                    // ON DELETE NO ACTION ON UPDATE NO ACTION
                    s = "ALTER TABLE \"public\".\"" + tableName + "\" ADD " + s.replaceAll("\r\n","") + ";\r\n";
                    foreignList.add(s);
                    s = "";
                }
                if(previous != null && isFirstDrop){
                    //对创建表再做一次检查
                    if(lowerAndUpper(s,");")){
                        createLock = true;
                    }
                    createTableSql += s;
                    if(createLock){
                        if(createTableSql != null && createTableSql != "" && createTableSql.contains(");") && lowerAndUpper(createTableSql,"CREATE") && lowerAndUpper(createTableSql,"TABLE")){
                            //mysql的外键key值去除
                            String[] array = createTableSql.split("\r\n");
                            createTableSql = "";
                            for(int i = 0;i < array.length;i++){
                                String startChar = "";
                                if(array[i].contains("\"")){
                                    startChar = array[i].substring(0,array[i].indexOf("\""));
                                }
                                //不是索引,只有KEY
                               if(!((lowerAndUpper(startChar,"KEY") || lowerAndUpper(startChar,"INDEX")) && !(lowerAndUpper(startChar,"FOREIGN") || lowerAndUpper(startChar,"PRIMARY")))){
                                   if(i != (array.length - 1) && array[i + 1].contains(");") && array[i].charAt(array[i].length() - 1) == ','){
                                      array[i] = array[i].substring(0,array[i].lastIndexOf(","));
                                   }
                                   createTableSql += array[i] + "\r\n";
                                }else {
                                   String elseName = "";
                                   int firstYinhaoIndex = array[i].indexOf("\"") + 1;
                                   for(int j = firstYinhaoIndex;j < array[i].length();j++){
                                       if(array[i].charAt(j) == '\"'){
                                           break;
                                       }
                                       elseName += array[i].charAt(j);
                                   }
                                   String indexName = array[i].substring(array[i].indexOf("(") + 1,array[i].lastIndexOf(")"));
                                   String indexSql = "CREATE INDEX " + elseName + " ON " + tableName + "(" + indexName + ");\r\n";
                                   indexList.add(indexSql);
                               }
                            }
                            //逗号去除
                            String removeCommas = "";
                            if(createTableSql.contains(",") && createTableSql.contains(");")){
                                removeCommas = createTableSql.substring(createTableSql.lastIndexOf(",") + 1,createTableSql.lastIndexOf(");"));
                            }
                            if(removeCommas.equals("\r\n")){
                                String startChar = createTableSql.substring(0,createTableSql.lastIndexOf(","));
                                String endChar = createTableSql.substring(createTableSql.lastIndexOf(",") + 1);
                                createTableSql = startChar + endChar;
                            }
                        }
                        previous = createTableSql;
                        createTableSql = "";
                        bufferedWriter.write(previous);
                    }
                }
                previous = s;
            }
            //写入创建外键的sql语句
            for(String list:foreignList){
                bufferedWriter.write(list);
            }
            //写入索引的sql语句
            for(String list:indexList){
                bufferedWriter.write(list);
            }
            bufferedWriter.flush();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            try {
                bufferedReader.close();
                fileReader.close();
                bufferedWriter.close();
                fileWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return savePath;
    }

    /**
     * 判断大写和小写
     */
    public static boolean lowerAndUpper(String s,String upper){
        if(s.contains(upper) || s.contains(upper.toLowerCase())){
            return true;
        }else {
            return false;
        }
    }

    public static int stringIndex(String s,String upper){
        int index = s.indexOf(upper);
        if(index == -1){
            index = s.indexOf(upper.toLowerCase());
        }
        return index;
    }

    /**
     * 大小写都替换
     */
    public static String replaceLowerAndUpper(String s,String upper,String replacement){
        s = s.replace(upper,replacement);
        s = s.replace(upper.toLowerCase(),replacement);
        return s;
    }

    /**
     * 判断出入的字符串
     * @param s
     */
    public static String StringType(String s,String lowerCase,String replacement){
        String startChar;
        String endChar;
        String upperCase = lowerCase.toUpperCase();
        if(s.contains(lowerCase)){
            //小写
            startChar = s.substring(0,s.indexOf(lowerCase));
            endChar = s.substring(s.indexOf(lowerCase) + 1);
            if(startChar.contains("\"") && !endChar.contains("\"")){
                return s.replaceAll(lowerCase,replacement);
            }
        }else if(s.contains(upperCase)){
            //大写
            startChar = s.substring(0,s.indexOf(upperCase));
            endChar = s.substring(s.indexOf(upperCase) + 1);
            if(startChar.contains("\"") && !endChar.contains("\"")){
                return s.replaceAll(upperCase,replacement);
            }
        }
        return s;
    }

    /**
     * 数据库连接
     * @param
     */
    public static Connection databaseConnection(DBManage databaseManagement){
        Connection connection = null;
        try {
            Class.forName(databaseManagement.getDriver());
            String connectionUrl = "jdbc:" + databaseManagement.getConnectionType() + ":" + "//" + databaseManagement.getAddress() + ":" + databaseManagement.getPort() + "/" + databaseManagement.getDatabaseName();
            connection = DriverManager.getConnection(connectionUrl,databaseManagement.getUserName(),databaseManagement.getPassword());
            return connection;
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }


    public static void main(String[] args) {
        //mySqlRegular("D:\\sqlFile\\uploads\\63c6e098-73fd-4999-b289-b3d120a07e87.sql","test11111");
        //
        File file = new File("D:\\root\\projects\\adaptationMaster\\uploads\\czq测试系统5\\swiper-4.5.0/target/threem-0.0.1-SNAPSHOT.war");
        System.out.println(file.length());
        System.out.println(file.getName());
    }
}
