package com.zjty.adaptationmaster.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;

public class WriterBySort {
    private int currentIndex = -1;
    private Map<Integer,String> map = new TreeMap<>();
    private Writer contentWriter;
    private int size;

    public void setWriter(Writer writer) {
        this.contentWriter = writer;
    }
    public void setSize(int size) {
        this.size = size;
        if(currentIndex==size){
            try {
                contentWriter.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    public void insert(Integer key, String value){
        map.put(key,value);
        while (map.get(currentIndex+1)!=null){
            try {
                contentWriter.write(map.remove(currentIndex+1));
            } catch (IOException e) {
                e.printStackTrace();
            }
            currentIndex++;
            if(currentIndex == size){
                try {
                    contentWriter.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
