package com.zjty.adaptationmaster.adaptor.controller;

import com.alibaba.fastjson.JSON;
import com.zjty.adaptationmaster.adaptor.entity.AdaptRequest;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.service.AdaptationService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

@RestController
@RequestMapping("/adapt")
public class AdaptationController {
    @GetMapping("/getUUID")
    public ServerResponse getUUID(){
        return ServerResponse.success(UUID.randomUUID().toString());
    }
    @Autowired
    private AdaptationService adaptationService;
    @PostMapping("/adapt")
    public ServerResponse adapt(@RequestBody AdaptRequest adaptRequest) throws IOException {
        return adaptationService.adapt(adaptRequest.getProject(),adaptRequest.getRuleList(),adaptRequest.getUuid());
    }
    @PostMapping("/compile")
    public ServerResponse compile(@RequestBody AdaptRequest adaptRequest){
        System.out.print("编译");
        System.out.print(JSON.toJSONString(adaptRequest));
        return adaptationService.compile(adaptRequest.getProject(),adaptRequest.getUuid());
    }
    @PostMapping("/uploadDeploy")
    public ServerResponse uploadDeploy(@RequestBody AdaptRequest adaptRequest){
        return adaptationService.uploadDeploy(adaptRequest.getProject(),adaptRequest.getPath());
    }
    @PostMapping("/deploy")
    public ServerResponse deploy(@RequestBody AdaptRequest adaptRequest){
        return adaptationService.deploy(adaptRequest.getProject(),adaptRequest.getUuid());
    }
    @PostMapping("/startInApusic")
    public ServerResponse startInApusic(@RequestBody AdaptRequest adaptRequest){
        return adaptationService.start(adaptRequest.getProject(),adaptRequest.getUuid());
    }
    @PostMapping("/stopInApusic")
    public ServerResponse stopInApusic(@RequestBody AdaptRequest adaptRequest){
        return adaptationService.stop(adaptRequest.getProject(),adaptRequest.getUuid());
    }
    @PostMapping("/unzipProject")
    public ServerResponse unZipProject(@RequestBody AdaptRequest adaptRequest){
        return adaptationService.unZipProject(adaptRequest.getPath(),adaptRequest.getProject());
    }
}
