package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSON;
import com.github.wenhao.jpa.Specifications;
import com.zjty.adaptationmaster.adaptor.entity.Assembly;
import com.zjty.adaptationmaster.adaptor.entity.ListResponse;
import com.zjty.adaptationmaster.adaptor.repository.AssemblyDao;
import com.zjty.adaptationmaster.adaptor.service.AssemblyService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <h4>Description : 组件</h4>
 * @author : czq
 * @Date : 2019-12-07 11:05
 */
@Service
public class AssemblyServiceImpl implements AssemblyService{


    private final AssemblyDao assemblyDao;

    @Autowired
    public AssemblyServiceImpl(AssemblyDao assemblyDao) {
        this.assemblyDao = assemblyDao;
    }

    /**
     * 保存组件信息
     * @param assembly 组件信息
     * @return 返回结果
     */
    @Override
    public ServerResponse saveAssembly(Assembly assembly) {
        Assembly save = assemblyDao.save(assembly);
        return ServerResponse.success(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ServerResponse deleteAssembly(Integer id) {
        Assembly assembly = assemblyDao.getOne(id);
        assembly.setStatus(0);
        return ServerResponse.success("删除成功");
    }

    @Override
    public ServerResponse findAssembly(Integer page , Assembly assembly) {
        Specification<Assembly> spec = Specifications.<Assembly>and()
                .like(assembly.getName()!=null,"name","%"+assembly.getName()+"%")
                .eq("status",1)
                .build();
//        Pageable pageable = /*new */PageRequest.of(page-1, 10, Sort.Direction.DESC, "id");
        List<Assembly> assemblyList = assemblyDao.findAll(spec);
//        return ServerResponse.success(new ListResponse<>(assemblyDao.count(spec),assemblyList));
        return ServerResponse.success(assemblyList);
    }
}
