package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.entity.pomEntity.ProjectPom;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.PomDependency;
import org.dom4j.*;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class AnalysisPom {
    public static ProjectPom analysis(Path pomPath){
        ProjectPom projectPom = new ProjectPom();
        List<PomDependency> dependencies = new ArrayList<>();
        Document document = null;
        try {
            document = DocumentHelper.parseText(new String(Files.readAllBytes(pomPath)));
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Element rootElement = document.getRootElement();
        projectPom.setModelVersion(rootElement.elementText("modelVersion"));
        projectPom.setGroupId(rootElement.elementText("groupId"));
        projectPom.setArtifactId(rootElement.elementText("artifactId"));
        projectPom.setPackaging(rootElement.elementText("packing"));
        projectPom.setVersion(rootElement.elementText("version"));
        projectPom.setName(rootElement.elementText("name"));
        projectPom.setDescription(rootElement.elementText("description"));

        Element dependencies1 = rootElement.element("dependencies");
        List<Element> dependency = dependencies1.elements("dependency");
        for(Element element:dependency){
            PomDependency pomDependency = new PomDependency();
            pomDependency.setGroupId(element.elementText("groupId"));
            pomDependency.setArtifactId(element.elementText("artifactId"));
            pomDependency.setVersion(element.elementText("version"));
            dependencies.add(pomDependency);
        }
        projectPom.setDependencies(dependencies);
        return projectPom;
    }

}
