package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class Assessor {
    public static void main(String[] args) {
        Assessor assessor = new Assessor();
        Rule rule = new Rule();
        rule.setTarget("aa?*");
        rule.setReplacing("建议修改为bb");
        List<Rule> rules = new ArrayList<>();
        rules.add(rule);
        assessor.setRuleList(rules);
        Project project = new Project();
        project.setCodeUrl("D:\\project\\bservice");
        assessor.assess(project);
    }
    List<Rule> ruleList;

    public void setRuleList(List<Rule> ruleList) {
        this.ruleList = ruleList;
    }

    List<Warn> warnList = new ArrayList<>();
    int lineNum = 0;
    public void assess(Project project){
        try {
            Files.walkFileTree(Paths.get(project.getCodeUrl()), new SimpleFileVisitor<Path>(){
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    List<String> allLines;
                    try {
                        allLines = Files.readAllLines(file);
                    }catch (MalformedInputException e){
                        return FileVisitResult.CONTINUE;
                    }
                    lineNum += allLines.size();
                    for(int i = 0;i<allLines.size();i++){
                        String s = allLines.get(i);
                        for(Rule rule:ruleList){
                            if (s.indexOf(rule.getTarget())>-1){
                                warnList.add(new Warn(file,i+1,rule.getTarget(),rule.getReplacing()));
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
        for(Warn warn:warnList){
            System.out.println(warn);
        }
    }
//    public class ProjectFile{
//        private Path path;
//        private BasicFileAttributes attributes;
//        private List<String> allLines;
//    }
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public class Warn{
        private Path path;
        private int line;
        private String keyWord;
        private String suggest;
    }
}
