package com.zjty.adaptationmaster.utils;

import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.base.enums.Const;
import org.apache.maven.shared.invoker.*;
import org.apache.maven.shared.utils.cli.CommandLineException;

import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class MavenCompiler {

    private Project project;
    private String mavenHome;
    private String webSocketId;

    public MavenCompiler(Project project,String mavenHome,String webSocketId){
        this.project = project;
        this.mavenHome = mavenHome;
        this.webSocketId = webSocketId;
    }

    public void compiler(){
        System.out.print("wwwwwww");
        InvocationRequest request1 = new DefaultInvocationRequest();
        request1.setPomFile(new File(project.getReport().getCompileFilePath()));
        request1.setGoals(Collections.singletonList("clean"));

        InvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(project.getReport().getCompileFilePath()));
        request.setGoals(Collections.singletonList("package"));

        Invoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));

        invoker.setOutputHandler(new InvocationOutputHandler() {
            @Override
            public void consumeLine(String s) throws IOException {
                WebSocketServer.sendIn(webSocketId,"自动编译："+project.getProjectName()+s);
                System.out.println(s);
            }
        });
        try {
            invoker.execute(request1);
            InvocationResult execute = invoker.execute(request);
            CommandLineException executionException = execute.getExecutionException();
            if(executionException==null){
                if(execute.getExitCode()==0){
                    project.setCompileSuccess(true);
                }
            }else {
                WebSocketServer.sendIn(webSocketId,TimeUtil.getNowDate()+"项目编译:出错"+project.getProjectName());
            }
        } catch (MavenInvocationException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

//    public static void main(String[] args) {
//        Project project = new Project();
//        project.getReport().setCompileFilePath("C:\\home\\project\\rsc\\hrmbclient\\pom.xml");
//        MavenCompiler mavenCompiler = new MavenCompiler(project, Const.MAVENHOME,"aa");
//        mavenCompiler.compiler();
//    }
    public static void main(String[] args) {
        InvocationRequest request = new DefaultInvocationRequest();
        //request.setPomFile(new File("D:\\SingleHRManger1.0（scannerAndFriger）"));
        request.setPomFile(new File("C:\\home\\project\\rsc\\hrmbclient\\pom.xml"));
        /**
         * Available lifecycle phases are: validate, initialize, generate-sources, process-sources, generate-resources, process-resources, compile, process-classes, generate-test-sources, process-test-sources, generate-test-resources, process-test-resources, test-compile, process-test-classes, test, prepare-package, package, pre-integration-test, integration-test, post-integration-test, verify, install, deploy, pre-clean, clean, post-clean, pre-site, site, post-site, site-deploy. -> [Help 1]
         */
        request.setGoals(Collections.singletonList("package"));
        Invoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(Const.MAVENHOME));

        invoker.setOutputHandler(new InvocationOutputHandler() {
            @Override
            public void consumeLine(String s) throws IOException {
                System.out.println(s);
                //WebSocketServer.sendInfo(webSocketId,s,"编译","running",project.getProjectName());
                //System.out.println(s);
            }
        });
        try {
            invoker.execute(request);
        } catch (MavenInvocationException e) {
            e.printStackTrace();
        }
    }
}
