package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.repository.ReportDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ReportDao reportDao;


    @Transactional
    @Override
    public ServerResponse inspect(Project project) {
        if(project.getCodeUrl() != null && !project.getCodeUrl().equals("")){
            //Project project = projectDao.getOne(projectId);
            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
            suffixLanguageMapping.put("java",Report.Language.JAVA);
            suffixLanguageMapping.put("cpp",Report.Language.CPP);
            suffixLanguageMapping.put("py",Report.Language.PYTHON);
            suffixLanguageMapping.put("jsp",Report.Language.JSP);
            //suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
            Report report = new Inspector(project, suffixLanguageMapping).inspect();
            if(report.getPackagePath() == null){
                report.setPackagePath(project.getCodeUrl());
            }
            reportDao.save(report);
            Project one = projectDao.getOne(project.getId());
            one.setReport(report);
            return ServerResponse.success(report);
        }else{
            return ServerResponse.error("未上传源代码");
        }
    }
}
