package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.Assembly;
import com.zjty.adaptationmaster.adaptor.service.AssemblyService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-09 11:01
 */
@RestController
@RequestMapping("/assembly")
@Api(tags = "组件管理")
public class AssemblyController {
    private final AssemblyService assemblyService;

    @Autowired
    public AssemblyController(AssemblyService assemblyService) {
        this.assemblyService = assemblyService;
    }

    @PutMapping
    public ServerResponse saveAssembly(@RequestBody Assembly assembly){
        return assemblyService.saveAssembly(assembly);
    }

    @DeleteMapping("/{id}")
    public ServerResponse deleteAssembly(@PathVariable("id") Integer id){
        return assemblyService.deleteAssembly(id);
    }

    @PostMapping("/{page}")
    public ServerResponse findAssembly(@PathVariable("page") Integer page ,@RequestBody Assembly assembly){
        return assemblyService.findAssembly(page,assembly);
    }

}
