package com.zjty.adaptationmaster.adaptor.service.Impl;


import com.zjty.adaptationmaster.adaptor.entity.db.DBManage;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.service.DBManageService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DBManageServiceImpl implements DBManageService {

    @Autowired
    private DBManageDao databaseDao;
    @Value("${highgo.driver}")
    private String highDriver;
    @Value("${highgo.connectionType}")
    private String highConnectionType;
    @Value("${highgo.dbName}")
    private String highDBName;

    /**
     * 新增数据库配置文件
     * @param databaseManagement
     * @return
     */
    @Override
    @Transactional
    public ServerResponse saveDatabase(DBManage databaseManagement) {
        databaseManagement.setStatus(1);//1-未删除
        if(databaseManagement.getDatabaseType().equals("highgo")){
            databaseManagement.setDatabaseName(highDBName);
            databaseManagement.setDriver(highDriver);
            databaseManagement.setConnectionType(highConnectionType);
        }
        return ServerResponse.success(databaseDao.save(databaseManagement));
    }


    /**
     * 根据id删除数据库配置文件
     * @param id
     * @return
     */
    @Override
    @Transactional
    public ServerResponse deleteDatabase(Integer id) {
        databaseDao.delete(id,0);//逻辑删除
        return ServerResponse.success(id);
    }

    /**
     * 查找未被逻辑删除的数据库配置文件
     * @return
     */
    @Override
    public ServerResponse findDatabase() {
        return ServerResponse.success(databaseDao.findDatabaseManagementByStatus(1));
    }

}
