package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.zjty.adaptationmaster.adaptor.controller.WebSocketServer;
import com.zjty.adaptationmaster.adaptor.entity.db.*;
import com.zjty.adaptationmaster.adaptor.repository.DBManageDao;
import com.zjty.adaptationmaster.adaptor.repository.DBRecordDao;
import com.zjty.adaptationmaster.adaptor.service.DBMigrateService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Regular;
import com.zjty.adaptationmaster.utils.TimeUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class DBMigrateServiceImpl implements DBMigrateService {

    @Autowired
    private DBManageDao dbManageDao;
    @Autowired
    private DBRecordDao dbRecordDao;

    //线程池数量，合适的线程数量能让程序更快
    private static final int poolSize = 5;

    @Value("${highgo.driver}")
    private String highgoDriver;
    @Value("${highgo.connectionType}")
    private String highgoConnnectionType;
    @Value("${highgo.dbName}")
    private String highgoDBName;

    /**
     * 创建新数据库和数据库中的表
     */
    @Override
    public ServerResponse dbMigrate(DatabaseResponse databaseResponse) {
        if(databaseResponse != null && databaseResponse.getDatabaseName() != null){
            String uuid = null;
            if(databaseResponse.getUuid() != null){
                uuid = databaseResponse.getUuid();
            }
            System.out.println(uuid);
            String databaseName = databaseResponse.getDatabaseName();
            //查询新建的数据库是否存在
            ServerResponse serverResponse = findDBByDBType(databaseResponse.getId());
            String data = serverResponse.getData().toString();
            String dbName = data.substring(data.indexOf("[") + 1,data.lastIndexOf("]"));
            String[] dbNameArray = dbName.split(",");
            List<String> dbNameList1 = Arrays.asList(dbNameArray);
            List<String> dbNameList = new ArrayList<>();
            dbNameList1.forEach(db -> dbNameList.add(db.trim()));
            if(dbNameList != null && dbNameList.size() != 0 && dbNameList.contains(databaseName)){
                log.info("该数据库已存在，请重新填写数据库名称");
                return ServerResponse.error("该数据库已存在，请重新填写数据库名称");
            }
            //转换后的.sql返回值
            String path = "";
            //根据传入的生成数据库类型，查找未被删除的配置文件
            DBManage databaseManagement = dbManageDao.findDBManageByIdAndStatus(databaseResponse.getId(),1);
            //源数据库：mysql数据库  目标数据库：highgo
            if(databaseResponse.getCreateType().equals(DBName.highgoName) && databaseResponse.getSourceType().equals("mysql")){
                //生成数据库的名称
                //连接系统数据库，建立新数据库
                databaseManagement.setDatabaseName(highgoDBName);
                databaseManagement.setDriver(highgoDriver);
                databaseManagement.setConnectionType(highgoConnnectionType);
                Connection connection = Regular.databaseConnection(databaseManagement);
                boolean errorOccur = false;
                if(connection != null){
                    PreparedStatement preparedStatement = null;
                    try {
                        String createDatabase = "CREATE DATABASE \"" + databaseName + "\" WITH OWNER = \"" + databaseManagement.getUserName() + "\" ENCODING = 'UTF8' TEMPLATE template0;";
                        preparedStatement = connection.prepareStatement(createDatabase);
                        preparedStatement.execute();
                    } catch (SQLException e) {
                        e.printStackTrace();
                        log.info("创建数据库：" + databaseName + "出错");
                        errorOccur = true;
                    }finally {
                        try {
                            preparedStatement.close();
                            connection.close();
                            if(errorOccur){
                                return ServerResponse.error("创建数据库：" + databaseName + "出错");
                            }
                        } catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    //建立表及导入数据
                    DBManage dbManage1 = new DBManage();
                    BeanUtils.copyProperties(databaseManagement,dbManage1);
                    dbManage1.setDatabaseName(databaseName);
                    Connection connection1 = Regular.databaseConnection(dbManage1);
                    if(connection1 != null){
                        long a = System.currentTimeMillis();
                        path = Regular.mySqlRegular(databaseResponse.getSqlPath(),databaseName);
                        long b = System.currentTimeMillis();
                        System.out.println("替换规则时间为：" + (b - a));
                        File file = new File(path);
                        FileReader fileReader = null;
                        BufferedReader bufferedReader = null;
                        List<String> insertList = new ArrayList<>();
                        List<String> elseList = new ArrayList<>();
                        List<String> createTableList = new ArrayList<>();
                        PreparedStatement preparedStatement1 = null;
                        try {
                            fileReader = new FileReader(file);
                            bufferedReader = new BufferedReader(fileReader);
                            String s;
                            String sql = "";
                            ThreadPoolExecutor pool = new ThreadPoolExecutor(poolSize,poolSize,10, TimeUnit.SECONDS,new ArrayBlockingQueue<>(poolSize * 2));
                            pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                            while ((s = bufferedReader.readLine()) != null){
                                if(Regular.lowerAndUpper(s,"INSERT") && Regular.lowerAndUpper(s,"INTO")){
                                    insertList.add(s);
                                    continue;
                                }else if(Regular.lowerAndUpper(s,"FOREIGN") && Regular.lowerAndUpper(s,"KEY")){
                                    elseList.add(s);
                                    continue;
                                }else if(Regular.lowerAndUpper(s,"CREATE") && Regular.lowerAndUpper(s,"INDEX")){
                                    elseList.add(s);
                                    continue;
                                }
                                sql += s;
                                if(s.contains(";")){
                                    if(Regular.lowerAndUpper(s,"CREATE") && Regular.lowerAndUpper(s,"TABLE")){
                                        String tableName = s.substring(s.indexOf("\"") + 1,s.lastIndexOf("\""));
                                        WebSocketServer.sendIn(uuid, TimeUtil.getNowDate() + " 数据库适配：" + tableName + "表创建");
                                    }
                                    createTableList.add(sql);
                                    sql = "";
                                }
                            }
                            //创建表
                            String createTableSql = "";
                            if(createTableList != null && createTableList.size() != 0){
                                for(String create:createTableList){
                                    createTableSql += create;
                                }
                            }
                            try {
                                preparedStatement1 = connection1.prepareStatement(createTableSql);
                                preparedStatement1.execute();
                            }catch (Exception e){
                                return ServerResponse.error("创建表出错");
                            }
                            //数据插入
                            if(insertList != null && insertList.size() != 0){
                                for(String insert:insertList){
                                    int insertIndex = insert.indexOf("\"") + 1;
                                    String tableName = "";
                                    for(int j = insertIndex;j < insert.length();j++){
                                        if(insert.charAt(j) == '"'){
                                            break;
                                        }else {
                                            tableName += insert.charAt(j);
                                        }
                                    }
                                    WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 数据库适配：" + tableName + "表正在插入");
                                    SQLExecuteTask sqlExecuteTask = new SQLExecuteTask(dbManage1);
                                    sqlExecuteTask.setSql(insert);
                                    pool.submit(sqlExecuteTask);
                                    System.out.println("核心线程数" + pool.getPoolSize() + "\t" + "存活线程数：" + pool.getActiveCount() + "\t" + "等待数量：" +  pool.getQueue().size() +"\t" + "任务数量：" + pool.getTaskCount());
                                }
                            }
                            //数据库连接池关闭
                            pool.shutdown();
                            try {
                                pool.awaitTermination(1,TimeUnit.HOURS);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            //关闭后执行新建索引和外键的sql语句
                            String elseSql = "";
                            if(elseList != null && elseList.size() != 0){
                                for(String elseChar:elseList){
                                    WebSocketServer.sendIn(uuid,TimeUtil.getNowDate() + " 数据库适配：" + "创建索引或外键");
                                    elseSql += elseChar;
                                }
                            }
                            try {
                                preparedStatement1 = connection1.prepareStatement(elseSql);
                                preparedStatement1.execute();
                            }catch (Exception e){
                                return ServerResponse.error("执行新建索引和外键的sql语句出错");
                            }
                            System.out.println("sql执行时间为：" + (System.currentTimeMillis() - b));
                            log.info(databaseResponse.getSqlPath() + "执行完成");
                        } catch (Exception e) {
                            e.printStackTrace();
                        } finally {
                            try {
                                bufferedReader.close();
                                fileReader.close();
                                preparedStatement1.close();
                                connection1.close();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }else {
                    return ServerResponse.error("创建数据库时连接根数据库失败");
                }
            }
            //保存迁移记录到数据库
            DBRecord dbRecord = new DBRecord();
            if(databaseResponse.getSourceType() != null){
                dbRecord.setSourceType(databaseResponse.getSourceType());
            }
            if(databaseResponse.getCreateType() != null){
                dbRecord.setCreateType(databaseResponse.getCreateType());
            }
            if(databaseResponse.getDatabaseName() != null){
                dbRecord.setDbName(databaseResponse.getDatabaseName());
            }
            if(databaseManagement.getUserName() != null){
                dbRecord.setUserName(databaseManagement.getUserName());
            }
            if(databaseResponse.getSqlPath() != null){
                dbRecord.setSqlPath(databaseResponse.getSqlPath());
            }
            dbRecord.setCreateSqlPath(path);
            dbRecord.setCreateTime(new Date());
            dbRecord.setStatus(1);//未删除
            dbRecordDao.save(dbRecord);
        }
        return ServerResponse.success();
    }

    /**
     * 根据传入的数据库类型查询所有的数据库
     * @param id
     * @return
     */
    @Override
    public ServerResponse findDBByDBType(Integer id) {
        List<String> dbNameList = new ArrayList<>();
        DBNameReturn dbNameReturn = new DBNameReturn();
        DBManage databaseManagement = dbManageDao.findDBManageByIdAndStatus(id, 1);
        //highgo查询所有数据库
        if(databaseManagement.getDatabaseType().equals(DBName.highgoName)){
            databaseManagement.setDatabaseName(highgoDBName);
            databaseManagement.setDriver(highgoDriver);
            databaseManagement.setConnectionType(highgoConnnectionType);
            //获取数据库连接
            Connection connection = Regular.databaseConnection(databaseManagement);
            if (connection != null) {
                dbNameReturn.setStatus(1);//1-库为开启状态
                PreparedStatement preparedStatement = null;
                try {
                    String findDB = "select p.datname from pg_database p where p.datistemplate = false;";
                    preparedStatement = connection.prepareStatement(findDB);
                    preparedStatement.execute();
                    ResultSet resultSet = preparedStatement.getResultSet();
                    while (resultSet.next()){
                        dbNameList.add(resultSet.getString(1));
                    }
                } catch (SQLException e) {
                    e.printStackTrace();
                } finally {
                    try {
                        preparedStatement.close();
                        connection.close();
                    } catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }else {
                dbNameReturn.setStatus(0);//关闭
            }
        }
        dbNameReturn.setDbName(dbNameList);
        return ServerResponse.success(dbNameReturn);
    }
}
