package com.zjty.adaptationmaster.adaptor.service;

import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.ExcelUtil;
import com.zjty.adaptationmaster.utils.SeleniumUtils;
import com.zjty.adaptationmaster.utils.TestCase;
import lombok.extern.slf4j.Slf4j;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.*;

@Component
@Slf4j
public class SeleniumService {
    @Autowired
    private SeleniumUtils seleniumUtils;


    @Value("${testCaseExcelTable}")
    private String testCaseExcelTable;
    @Value("${createTxtPath}")
    private String createTxtPath;


    public ServerResponse autoTestCase(){
        List<TestCase> testCases=null;
        try {
            testCases = ExcelUtil.importExcel(0, 1, TestCase.class, new FileInputStream(testCaseExcelTable));
            String s = ElementAction(testCases);
            return ServerResponse.success("测试成功",s);
        } catch (Exception e) {
            e.printStackTrace();
            return ServerResponse.error("测试失败!"+e.getMessage());
        }

    }

    public String ElementAction(List<TestCase> steps) {
        WebDriver driver=null;
        StringBuilder sb=null;
        try {
            driver=seleniumUtils.initfifox();
            Random random=null;
            sb=new StringBuilder();
            for (TestCase step : steps) {
                Thread.sleep(500);
                if(step.getAction().equalsIgnoreCase("get")){
                    driver.get(step.getElement());
                    sb.append(step.getTitle()+" : "+step.getElement());
                }else if(step.getAction().equalsIgnoreCase("sendkeys")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    if(value.equalsIgnoreCase("random")){
                        random=new Random();
                        int i = random.nextInt(1000)+1000;
                        value="test"+i;
                    }
//                driver.findElement(By.xpath(step.getElement())).sendKeys(value);
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.sendKeys(value);
                    sb.append(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+" "+value+"\n");

                }else if(step.getAction().equalsIgnoreCase("click")){
//                driver.findElement(By.xpath(step.getElement())).click();
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.click();

                    sb.append(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+"\n");

                }else if(step.getAction().equalsIgnoreCase("gettext")){

                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    if("errorMsg".equalsIgnoreCase(step.getElement())){
                        if("".equals(webElement.getText())){
                            sb.append("登录成功!"+"\n");
                        }
                    }else {
                        webElement.getText();
                        sb.append(webElement.getText()+"\n");
                    }
                }else if(step.getAction().equalsIgnoreCase("readonly")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    JavascriptExecutor removeAttribute = (JavascriptExecutor)driver;
                    //remove readonly attribute
                    removeAttribute.executeScript("var setDate=document.getElementById(\""+step.getElement()+"\");setDate.removeAttribute('placeholder');");
                    WebElement webElement = selectType(step.getMethod(), step.getElement(), driver);
                    webElement.sendKeys("1990-01-02");
                    sb.append(step.getTitle()+": "+step.getElement()+" "+step.getMethod()+" "+step.getAction()+" "+value+"\n");

                }else if(step.getAction().equalsIgnoreCase("register")){
                    String value = step.getValue() == null ? "" : step.getValue();
                    if(value.equals(driver.getCurrentUrl())){
                        String text = driver.findElement(By.xpath(step.getElement())).getText();
                        sb.append(text+"\n");
                    }else {
                        String errorMsg = driver.findElement(By.id("errorMsg")).getText();
                        sb.append(errorMsg+"\n");
                    }
                }
            }
            sb.append("测试结束"+"\n");
//            writeTXT(createTxtPath,System.currentTimeMillis()+"",sb.toString());
            return sb.toString();
        }catch (Exception e){
            log.info("报错了:"+e.getMessage());
        }finally {
            if(driver!=null){
                driver.quit();
                driver=null;
            }
        }

        return null;//目前没有用，预留返回字段
    }
    public void writeTXT(String path,String title,String content){
        try {
            // 防止文件建立或读取失败，用catch捕捉错误并打印，也可以throw
            /* 写入Txt文件 */
            File writename = new File(path);// 相对路径，如果没有则要建立一个新的output。txt文件
            if(!writename.exists()){
                writename.mkdirs();
            }
            writename = new File(path+"\\"+title+".txt");// 相对路径，如果没有则要建立一个新的output。txt文件
            writename.createNewFile(); // 创建新文件
            BufferedWriter out = new BufferedWriter(new FileWriter(writename));
            out.write(content); // \r\n即为换行
            out.flush(); // 把缓存区内容压入文件
            out.close(); // 最后记得关闭文件

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private WebElement selectType(String method, String element, WebDriver driver) {
        WebElement element1=null;
        if(method.equalsIgnoreCase("xpath")){
            element1 = driver.findElement(By.xpath(element));
        }else if(method.equalsIgnoreCase("css")){
            element1=driver.findElement(By.cssSelector(element));
        }else if(method.equalsIgnoreCase("id")){
            element1=driver.findElement(By.id(element));
        }else if(method.equalsIgnoreCase("name")){
            element1=driver.findElement(By.name(element));
        }
        return element1;
    }

}
