package com.zjty.adaptationmaster.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.zjty.adaptationmaster.adaptor.entity.Reports;
import com.zjty.adaptationmaster.adaptor.entity.Step;
import org.apache.poi.ss.usermodel.Workbook;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

/**
 * <p>Description : selenium-test
 * <p>Date : 2020/1/3 10:58
 * <p>@author : C
 */
public class ExcelUtil {


    /**
     * 解析excel文件
     * @param titleRows 标题行
     * @param headRows 头行
     * @param pojoClass 类型
     * @param inputStream 文件
     * @return list
     */
    public static <T> List<T> importExcel(int titleRows, int headRows, Class<T> pojoClass, InputStream inputStream) throws Exception {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows);
        params.setHeadRows(headRows);
        List<T> arrayList;
        arrayList = ExcelImportUtil.importExcel(
                inputStream,
                pojoClass, params);
        return arrayList;
    }


    public static Workbook exportExcel(Reports report) {
        String sheet = "测试报告";
        return ExcelExportUtil.exportExcel(new ExportParams(report.getSystem(), report.getExplorer(), sheet),
                Reports.class, report.getSteps());
    }

    public static void exportExcel(HttpServletResponse response, Reports report) {
        try {
            String sheet = "测试报告";
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + new String((sheet + ".xls").getBytes("gb2312"), "ISO-8859-1"));
            OutputStream stream = response.getOutputStream();
            Workbook workbook = ExcelExportUtil.exportExcel(new ExportParams(report.getSystem(), report.getExplorer(), sheet),
                    Step.class, report.getSteps());
            workbook.write(stream);
            stream.flush();
            stream.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Object mapToObject(Map<Object, Object> map, Class<?> beanClass) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            obj = beanClass.newInstance();
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (Field field : fields) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                continue;
            }
            field.setAccessible(true);
            if (map.containsKey(field.getName())) {
                try {
                    if (map.get(field.getName()) == null) {
                        field.set(obj, "");
                    } else {
                        field.set(obj, map.get(field.getName()));
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return obj;
    }
}
