package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.adaptor.service.AdaptationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Service
public class AdaptationServiceImpl implements AdaptationService {
    @Autowired
    private Adaptor adaptor;

    @Override
    public ServerResponse adapt(HttpServletResponse response) throws IOException {

        Rule rule = new Rule();
        rule.setPathMatchType(Rule.MatchType.NAME);
        rule.setPath("pom.xml");
        rule.setTextMatching(Rule.TextMatch.AREA);
        rule.setTarget("<groupId>||mysql||</groupId>");
        rule.setReplacing("<groupId>org.postgresql</groupId>");
        List<Rule> objects = new ArrayList<>();
        objects.add(rule);

        //Adaptor adaptor = new Adaptor(adaptationDetailLogEntityDao, originalFileDao);
        adaptor.setWriter(response.getWriter());
        adaptor.setRuleList(objects);
        adaptor.setProjectPath("C:\\home\\project\\rsc\\hrmbclient");
        adaptor.doAdapt();
        return ServerResponse.success();
    }
}
