package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSON;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.entity.ReportEntity;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.Dependency;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.repository.ReportDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ReportDao reportDao;


    @Transactional
    @Override
    public ServerResponse inspect(Project project) {
        if(project.getCodeUrl() != null && !project.getCodeUrl().equals("")){
            //Project project = projectDao.getOne(projectId);
//            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
//            suffixLanguageMapping.put("java",Report.Language.JAVA);
//            suffixLanguageMapping.put("cpp",Report.Language.CPP);
//            suffixLanguageMapping.put("py",Report.Language.PYTHON);
//            suffixLanguageMapping.put("jsp",Report.Language.JSP);
//            suffixLanguageMapping.put("asp",Report.Language.ASP);
//            //suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
//            LoggerFactory.getLogger(getClass()).info("这里rulelist为空，需要设置");
            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
            suffixLanguageMapping.put("java",Report.Language.JAVA);
            suffixLanguageMapping.put("cpp",Report.Language.CPP);
            suffixLanguageMapping.put("py",Report.Language.PYTHON);
            suffixLanguageMapping.put("jsp",Report.Language.JSP);
            suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
            suffixLanguageMapping.put("js",Report.Language.JAVASCRIPT);
            suffixLanguageMapping.put("go",Report.Language.GO);

            List<Rule> ruleList = new ArrayList<>();
            //com.mysql.cj.jdbc.Driver//com.mysql.jdbc.Driver
            ruleList.add(new Rule("com.mysql.cj.jdbc.Driver","建议修改为postgresql数据库驱动"));
            ruleList.add(new Rule("com.mysql.jdbc.Driver","建议修改为postgresql数据库驱动"));
            //net.sourceforge.jtds.jdbc.Driver//sqlserver
            ruleList.add(new Rule("net.sourceforge.jtds.jdbc.Driver","建议修改为postgresql数据库驱动"));
            //COM.ibm.db2.jdbc.app.DB2Driver//com.ibm.db2.jcc.DB2Driver//COM.ibm.db2.jdbc.net.DB2Driver//com.ibm.db2.jcc.DB2Driver
            ruleList.add(new Rule("DB2Driver","建议修改为postgresql数据库驱动"));
            //oracle.jdbc.OracleDriver//oracle.jdbc.driver.OracleDriver
            ruleList.add(new Rule("OracleDriver","建议修改为postgresql数据库驱动"));

            ruleList.add(new Rule("mysql-connector-java","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.microsoft.sqlserver","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.oracle","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.mariadb.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.sap.cloud.db.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.ibm.informix","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.firebirdsql.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.hsqldb","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.h2database","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.apache.derby","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.mongodb","建议修改为postgresql依赖声明"));

            ruleList.add(new Rule("public native","这里用到了JNI"));
            ruleList.add(new Rule("<packaging>jar</packaging>","建议修改打包方式为war包并排除掉springboot内置的tomcat,以部署到国产化中间件上"));
            ruleList.add(new Rule("WebOffice","这里用到了weboffice文档展示编辑插件"));
            ruleList.add(new Rule("pdfobject.min.js","这里用到了pdf文档展示插件"));
            ruleList.add(new Rule("pdfobject.js","这里用到了pdf文档展示插件"));
            ruleList.add(new Rule(".swf","这里用到了flash流媒体播放插件"));

            Report report = new Inspector(project, suffixLanguageMapping, ruleList).inspect();

            ReportEntity reportEntity = new ReportEntity();
            reportEntity.setCompileFilePath(report.getCompileFilePath());
            reportEntity.setDatabaseType(report.getDatabaseType());
            reportEntity.setDependenceManagement(report.getDependenceManagement());
            reportEntity.setFileNum(report.getFileNum());
            reportEntity.setFramework(report.getFramework());
            reportEntity.setIsSeparate(report.getIsSeparate());
            reportEntity.setLanguage(report.getLanguage());
            reportEntity.setPackagePath(report.getPackagePath());

            List<Dependency> dependencies = report.getDependencies();
            String s = JSON.toJSONString(dependencies);
            List<Inspector.Warn> warnList = report.getWarnList();
            String s1 = JSON.toJSONString(warnList);
            reportEntity.setWarnList(s1);
            List<String> jarPath = report.getJarPath();
            String s2 = JSON.toJSONString(jarPath);
            reportEntity.setJarPath(s2);
            reportEntity.setDependence(s);


            if(report.getPackagePath() == null){
                report.setPackagePath(project.getCodeUrl());
            }
            Project one = projectDao.getOne(project.getId());
            ReportEntity reportEntitySave = reportDao.save(reportEntity);
            one.setReport(reportEntitySave);
            report.setId(reportEntitySave.getId());
            return ServerResponse.success(report);
        }else{
            return ServerResponse.error("未上传源代码");
        }
    }

    @Override
    public Report getReportById(Integer id) {
        ReportEntity one = reportDao.getOne(id);
        Report report = new Report();
        report.setId(one.getId());
        List<Dependency> dependencies = JSON.parseArray(one.getDependence(), Dependency.class);
        report.setDependencies(dependencies);
        report.setDatabaseType(one.getDatabaseType());
        report.setLanguage(one.getLanguage());
        report.setPackagePath(one.getPackagePath());
        report.setCompileFilePath(one.getCompileFilePath());
        report.setDependenceManagement(one.getDependenceManagement());
        report.setFileNum(one.getFileNum());
        report.setLineNum(one.getLineNum());
        report.setFramework(one.getFramework());
        report.setIsSeparate(one.getIsSeparate());

        List<Inspector.Warn> warns = JSON.parseArray(one.getWarnList(), Inspector.Warn.class);
        report.setWarnList(warns);

        List<String> path = JSON.parseArray(one.getJarPath(), String.class);
        report.setJarPath(path);
        return report;
    }
}
