package com.zjty.adaptationmaster.adaptor.service.Impl;

import com.alibaba.fastjson.JSON;
import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Report;
import com.zjty.adaptationmaster.adaptor.entity.ReportEntity;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.repository.PomDependencyDao;
import com.zjty.adaptationmaster.adaptor.entity.pomEntity.SecondFloor.PomDependency;
import com.zjty.adaptationmaster.adaptor.repository.ProjectDao;
import com.zjty.adaptationmaster.adaptor.repository.ReportDao;
import com.zjty.adaptationmaster.adaptor.service.InspectService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import com.zjty.adaptationmaster.utils.Inspector;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;

@Service
public class InspectServiceImpl implements InspectService {
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ReportDao reportDao;
    @Autowired
    private PomDependencyDao pomDependencyDao;

    @Transactional
    @Override
    public ServerResponse inspect(Project project,String uuid) {
        if(project.getCodeUrl() != null && !project.getCodeUrl().equals("")){
            //Project project = projectDao.getOne(projectId);
//            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
//            suffixLanguageMapping.put("java",Report.Language.JAVA);
//            suffixLanguageMapping.put("cpp",Report.Language.CPP);
//            suffixLanguageMapping.put("py",Report.Language.PYTHON);
//            suffixLanguageMapping.put("jsp",Report.Language.JSP);
//            suffixLanguageMapping.put("asp",Report.Language.ASP);
//            //suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
//            LoggerFactory.getLogger(getClass()).info("这里rulelist为空，需要设置");
            Map<String, Report.Language> suffixLanguageMapping = new HashMap<>();
            suffixLanguageMapping.put("java",Report.Language.JAVA);
            suffixLanguageMapping.put("cpp",Report.Language.CPP);
            suffixLanguageMapping.put("py",Report.Language.PYTHON);
            suffixLanguageMapping.put("jsp",Report.Language.JSP);
            suffixLanguageMapping.put("html",Report.Language.ONLYVIEW);
            suffixLanguageMapping.put("js",Report.Language.JAVASCRIPT);
            suffixLanguageMapping.put("go",Report.Language.GO);

            List<Rule> ruleList = new ArrayList<>();
            //com.mysql.cj.jdbc.Driver//com.mysql.jdbc.Driver
            ruleList.add(new Rule("com.mysql.cj.jdbc.Driver","建议修改为postgresql数据库驱动"));
            ruleList.add(new Rule("com.mysql.jdbc.Driver","建议修改为postgresql数据库驱动"));
            //net.sourceforge.jtds.jdbc.Driver//sqlserver
            ruleList.add(new Rule("net.sourceforge.jtds.jdbc.Driver","建议修改为postgresql数据库驱动"));
            //COM.ibm.db2.jdbc.app.DB2Driver//com.ibm.db2.jcc.DB2Driver//COM.ibm.db2.jdbc.net.DB2Driver//com.ibm.db2.jcc.DB2Driver
            ruleList.add(new Rule("DB2Driver","建议修改为postgresql数据库驱动"));
            //oracle.jdbc.OracleDriver//oracle.jdbc.driver.OracleDriver
            ruleList.add(new Rule("OracleDriver","建议修改为postgresql数据库驱动"));

            ruleList.add(new Rule("mysql-connector-java","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.microsoft.sqlserver","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.oracle","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.mariadb.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.sap.cloud.db.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.ibm.informix","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.firebirdsql.jdbc","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.hsqldb","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("com.h2database","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.apache.derby","建议修改为postgresql依赖声明"));
            ruleList.add(new Rule("org.mongodb","建议修改为postgresql依赖声明"));

            ruleList.add(new Rule("public native","这里用到了JNI"));
            ruleList.add(new Rule("<packaging>jar</packaging>","建议修改打包方式为war包并排除掉springboot内置的tomcat,以部署到国产化中间件上"));
            ruleList.add(new Rule("WebOffice","这里用到了weboffice文档展示编辑插件"));
            ruleList.add(new Rule("webOffice","这里用到了weboffice文档展示编辑插件"));
            ruleList.add(new Rule("weboffice","这里用到了weboffice文档展示编辑插件"));
            ruleList.add(new Rule("Weboffice","这里用到了weboffice文档展示编辑插件"));
            ruleList.add(new Rule("pdfobject.min.js","这里用到了pdf文档展示插件"));
            ruleList.add(new Rule("pdfobject.js","这里用到了pdf文档展示插件"));
            ruleList.add(new Rule(".swf","这里用到了flash流媒体播放插件"));

            Report report = new Inspector(project, suffixLanguageMapping, ruleList,uuid).inspect();

            ReportEntity reportEntity = new ReportEntity();
            reportEntity.setCompileFilePath(report.getCompileFilePath());
            reportEntity.setDatabaseType(report.getDatabaseType());
            reportEntity.setDependenceManagement(report.getDependenceManagement());
            reportEntity.setFileNum(report.getFileNum());
            reportEntity.setFramework(report.getFramework());
            reportEntity.setIsSeparate(report.getIsSeparate());
            reportEntity.setLanguage(report.getLanguage());
            reportEntity.setLineNum(report.getLineNum());
            reportEntity.setCreateTime(new Date().getTime());
            reportEntity.setPackagePath(report.getPackagePath());

            List<Inspector.Warn> warnList = report.getWarnList();
            String s1 = JSON.toJSONString(warnList);
            reportEntity.setWarnList(s1);
            List<String> jarPath = report.getJarPath();
            String s2 = JSON.toJSONString(jarPath);
            reportEntity.setJarPath(s2);
            if(report.getPackagePath() == null){
                reportEntity.setPackagePath(project.getCodeUrl());
            }

            ReportEntity reportEntitySave = reportDao.save(reportEntity);
            Project one = projectDao.getOne(project.getId());
            List<PomDependency> dependencies = report.getDependencies();
            for (PomDependency dependency : dependencies) {
                dependency.setReportId(reportEntitySave.getId());
            }
            pomDependencyDao.saveAll(dependencies);
            one.setReport(reportEntitySave);
            return ServerResponse.success(reportEntitySave);
        }else{
            return ServerResponse.error("未上传源代码");
        }
    }

    @Override
    public ServerResponse getReportById(Integer id) {
        ReportEntity one = reportDao.getOne(id);
        Report report = new Report();

        List<PomDependency> allByReportIdEquals = pomDependencyDao.findAllByReportIdEquals(id);
        report.setId(one.getId());
        report.setDependencies(allByReportIdEquals);
        report.setDatabaseType(one.getDatabaseType());
        report.setLanguage(one.getLanguage());
        report.setPackagePath(one.getPackagePath());
        report.setCompileFilePath(one.getCompileFilePath());
        report.setDependenceManagement(one.getDependenceManagement());
        report.setFileNum(one.getFileNum());
        report.setLineNum(one.getLineNum());
        report.setFramework(one.getFramework());
        report.setIsSeparate(one.getIsSeparate());
        report.setCreateTime(one.getCreateTime());

        List<Inspector.Warn> warns = JSON.parseArray(one.getWarnList(), Inspector.Warn.class);
        report.setWarnList(warns);

        List<String> path = JSON.parseArray(one.getJarPath(), String.class);
        report.setJarPath(path);
        return ServerResponse.success(report);
    }

    @Override
    public ServerResponse getPrintReport(Integer id) {
        ReportEntity one = reportDao.getOne(id);
        //Project one1 = projectDao.getOne(id);
//        Report report = new Report();
//
//        List<PomDependency> allByReportIdEquals = pomDependencyDao.findAllByReportIdEquals(id);
//        report.setId(one.getId());
//        report.setDependencies(allByReportIdEquals);
//        report.setDatabaseType(one.getDatabaseType());
//        report.setLanguage(one.getLanguage());
//        report.setPackagePath(one.getPackagePath());
//        report.setCompileFilePath(one.getCompileFilePath());
//        report.setDependenceManagement(one.getDependenceManagement());
//        report.setFileNum(one.getFileNum());
//        report.setLineNum(one.getLineNum());
//        report.setFramework(one.getFramework());
//        report.setIsSeparate(one.getIsSeparate());
//        report.setCreateTime(one.getCreateTime());
//
//        List<Inspector.Warn> warns = JSON.parseArray(one.getWarnList(), Inspector.Warn.class);
//        report.setWarnList(warns);
//
//        List<String> path = JSON.parseArray(one.getJarPath(), String.class);
//        report.setJarPath(path);
        String result = "评估报告------------"+
                "\t评估时间："+ new Date(one.getCreateTime())+//LocalDateTime.ofEpochSecond(one.getCreateTime(),0, ZoneOffset.ofHours(8))+
                "\n系统名称："+/*one1.getProjectName()+*/
                "\n\n语言:"+one.getLanguage()+"\t"+
                "\t架构：未知"+
                "\t前后端分离：未知"+
                "\n数据库类型："+(one.getDatabaseType()==null?"未知":one.getDatabaseType())+
                "\t文件数量："+one.getFileNum()+
                "\t代码行数："+one.getLineNum();
        StringBuilder stringBuilder = new StringBuilder(result);
        List<Inspector.Warn> warns = JSON.parseArray(one.getWarnList(), Inspector.Warn.class);
        int i = 1;
        for(Inspector.Warn warn:warns){
            stringBuilder.append("\n\n"+i+++"、所在文件："+warn.getPath()+",行数："+warn.getLine()+",关键字："+warn.getKeyWord()+
                    "\n建议："+warn.getSuggest());
        }
        System.out.println(stringBuilder.toString());
        return ServerResponse.success(stringBuilder.toString());
    }

}
