package com.zjty.adaptationmaster.adaptor.enginer;

import org.apache.commons.io.FileUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.*;

public class Engine {

    //判断一个文件够不够称作大文件的阈值，大文件单独占用一个线程，小文件凑够阈值合用一个线程
    private final static long LIMIT = 200*1024;

    private String path;
    private String projectName;
    private List<AdaptorEntity> adaptorEntities;
    private ThreadPoolExecutor pool;

    public int threadNum;

    public void setPath(String path) {
        this.path = path;
    }
    public void setProjectName(String name){
        this.projectName = name;
    }
    public void initAdaptorEntities(List adaptorEntities){
        this.adaptorEntities = adaptorEntities;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public void addAdaptorEntities(List adaptorEntities){
        if(this.adaptorEntities == null)this.adaptorEntities = new ArrayList<>();
        this.adaptorEntities.addAll(adaptorEntities);
    }

    long beginTime ;
    public void enginer(){
        pool = new ThreadPoolExecutor(threadNum, threadNum, 10, TimeUnit.SECONDS, new ArrayBlockingQueue<>(400));
        pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        beginTime = System.currentTimeMillis();
        System.out.println(beginTime+"开始时间,线程池数量"+threadNum);
        doDir(path);
        pool.shutdown();
        try {
            //该方法会被阻塞，直到子线程全部执行完毕，并且shutdown()方法被调用，或者等待时间超时。这里等待时间设置一小时
            pool.awaitTermination(1,TimeUnit.HOURS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        long l = System.currentTimeMillis();
        System.out.println("所有线程执行完毕"+l+"总时间差"+(l-beginTime));
    }

    final Counter i = new Counter();
    SmallFileRepository repository = new SmallFileRepository();
    private void doDir(String path){
        //final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.{java,txt,properties}");
        //Collection<File> files = FileUtils.listFiles(new File(path), null, true);

        Iterator<File> fileIterator = FileUtils.iterateFiles(new File(path), new String[]{"java","txt","properties"}, true);

        while (fileIterator.hasNext()){
            File next = fileIterator.next();
            long length = next.length();
            if(length>LIMIT) {
                System.out.println("大文件出没");
                List<File> files = new ArrayList<>();
                files.add(next);
                execute(files);
            } else {
                repository.fileList.add(next);
                repository.length+=length;
                if(repository.length>LIMIT){
                    execute(repository.fileList);
                    repository.length=0;
                    repository.fileList = new ArrayList<>();
                }
            }
            i.plus();
                //List<String> stringList = FileUtils.readLines(fileIterator.next(), "utf-8");

                //execute(stringFactory);
        }
//        try {
//            Files.walkFileTree(Paths.get(path),new SimpleFileVisitor<Path>(){
//                @Override
//                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
//
//                    StringTask task = new StringTask(file,pathMatcher);
//                    execute(task);
//                    i.plus();
//                    //过滤文件名后缀
////                    if(pathMatcher.matches(file)){
////                        i.plus();
////                        List<String> list = Files.readAllLines(file);
////                        if(list.size()>200){
////                            //System.out.println("文件够大，开线程"+file);
////                            execute(new StringFactory().setProduct(list));
////                            //new StringFactory().setProduct(list).run();
////                        }else {
////                            //System.out.println("文件不够大，存起来"+file);
////                            stringList.addAll(list);
////                            if(stringList.size()>200){
////                                //System.out.println("存够了，开线程");
////                                ArrayList<String> strings = new ArrayList<>();
////                                strings.addAll(stringList);
////                                execute(new StringFactory().setProduct(strings));
////                                //new StringFactory().setProduct(strings).run();
////                                stringList.clear();
////                            }
////                        }
////                    }
//                    return FileVisitResult.CONTINUE;
//                }
//                @Override
//                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
//                    return FileVisitResult.CONTINUE;
//                }
            //};
//            if(stringList.size()>0){
//                ArrayList<String> strings = new ArrayList<>();
//                strings.addAll(stringList);
//                execute(new StringFactory().setProduct(strings));
//                //new StringFactory().setProduct(strings).run();
//            }
        long endTime = System.currentTimeMillis();
            System.out.println(endTime+"结束时间");
            System.out.println(i.getI()+"处理总数量");
        System.out.println((endTime-beginTime)+"时间差");
        i.reset();
    }
    List<Runnable> rejectedTask = new ArrayList<>();
    private void execute(List<File> files){
        ApacheTask stringFactory = new ApacheTask();
        stringFactory.setFile(files);
        pool.submit(stringFactory);
    }

    /**
     * 文件如果过小，先存起来，大小存够了再交给一个线程去处理
     */
    private class SmallFileRepository{
        public long length = 0;
        public List<File> fileList = new ArrayList<>();
    }

    public static void main(String[] args) {
        Engine engine = new Engine();
        engine.setPath("C:\\Users\\wyl\\Desktop\\testReplace");
        //engine.setPath("C:\\Users\\wyl\\Desktop\\testReplace\\testReplace1\\java\\com\\zjty\\hrmanager\\base\\request");
        engine.setProjectName("testReplace");
        List<AdaptorEntity> adaptorEntities = new ArrayList<>();
        adaptorEntities.add(new AdaptorEntity(MatchType.ALL,"**/resources/*.properties","log4j","log5j"));
        engine.initAdaptorEntities(adaptorEntities);
        for(int i = 10;i<200;i++){
            engine.setThreadNum(i);
            engine.enginer();
        }
    }
}
