package com.zjty.adaptationmaster.adaptor.enginer;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class Engine1 {
    private static final String path = "C:\\Users\\wyl\\Desktop\\testReplace";

    private long totalSize;
    private ReadedFileRepository repository = new ReadedFileRepository();

    public void readFile(){
        //List<>
        try {
            Files.walkFileTree(Paths.get(path),new SimpleFileVisitor<Path>(){
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String s = new String(Files.readAllBytes(file));
                    ReadedFile readedFile = new ReadedFile(s,attrs);
                    if(repository.put(readedFile)){
                        ApacheTask apacheTask = new ApacheTask();
                        //apacheTask.setFile(repository.getReadedFiles());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    //先把文件读取到内存中
    private class ReadedFileRepository{
        private static final long LIMIT = 200*1024*1024;//字节*k*m

        private List<ReadedFile> readedFiles;
        private long count;

        public List<ReadedFile> getReadedFiles() {
            return readedFiles;
        }

        public boolean put(ReadedFile readedFile){
            if(readedFile==null)readedFiles = new ArrayList<>();
            readedFiles.add(readedFile);
            count+=readedFile.getAttributes().size();
            if(count>LIMIT){
                return true;
            }
            return false;
        }
    }
}
