package com.zjty.adaptationmaster.adaptor.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * <h4>Description : adaptation-master</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2019-12-07 16:37
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class Rule {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    private String transformBefore;//改造前字段

    private String transformAfter;//

    private String type;//替换类型（文件替换、字符替换、正则替换）

    private String suffix;//替换的文件后缀（list的String）

    private Integer status = 1;//状态（0：删除 1：未删除）

    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    @JSONField(serialize = false)
    @JoinColumn(name = "projectId")
    private Project project;//所属的项目

    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    @JSONField(serialize = false)
    @JoinColumn(name = "ruleSetId")
    private RuleSet ruleSet;//所属的规则集
}
