package com.zjty.adaptationmaster.adaptor.controller;

import com.zjty.adaptationmaster.adaptor.entity.Project;
import com.zjty.adaptationmaster.adaptor.entity.Rule;
import com.zjty.adaptationmaster.adaptor.service.AdaptationService;
import com.zjty.adaptationmaster.base.response.ServerResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

@Controller
@RequestMapping("/adapt")
public class AdaptationController {
    @GetMapping("/getUUID")
    public ServerResponse getUUID(){
        return ServerResponse.success(UUID.randomUUID().toString());
    }
    @Autowired
    private AdaptationService adaptationService;
    @PostMapping("/adapt")
    public ServerResponse adapt(Project project, List<Rule> ruleList,String uuid) throws IOException {
        return adaptationService.adapt(project,ruleList,uuid);
    }
    @PostMapping("/compile")
    public ServerResponse compile(Project project,String uuid){
        return adaptationService.compile(project,uuid);
    }
    @PostMapping("/deploy")
    public ServerResponse deploy(Project project,String uuid){
        return adaptationService.deploy(project,uuid);
    }
    @PostMapping("/startInApusic")
    public ServerResponse startInApusic(Project project,String uuid){
        return adaptationService.start(project,uuid);
    }
    @PostMapping("/stopInApusic")
    public ServerResponse stopInApusic(Project project,String uuid){
        return adaptationService.stop(project,uuid);
    }
    @PostMapping("/unzipProject")
    public ServerResponse unZipProject(String path,Project project){
        return adaptationService.unZipProject(path,project);
    }
}
